/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.Description;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.IntegerArgument;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.minecraft.command.ButtonType;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.argument.Parsers;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class RankingCommands {
    private static final CommandArgument<Commander, RankLadder> LADDER_ARG = RankingCommands.ladderArgument(true);
    private static final CommandFlag<Void> FLAG_RELATIVE = CommandFlag.newBuilder("relative").withDescription(Description.of("Whether the <index> argument should be relative to the current position of the rank")).withAliases("r").build();

    private static CommandArgument<Commander, RankLadder> ladderArgument(boolean required) {
        CommandArgument.Builder ladder = CommandArgument.ofType(RankLadder.class, "ladder").withParser(Parsers.rankLadder());
        if (!required) {
            ladder.asOptionalWithDefault("default");
        }
        return ladder.build();
    }

    private RankingCommands() {
    }

    static void register(CommandRegistrationContext ctx) {
        ctx.push(ctx.head().argument(LADDER_ARG, Description.of("the rank ladder to work on")), child -> {
            ctx.register(RankingCommands.list(ctx.head()));
            ctx.register(RankingCommands::add, "add", "+");
            ctx.register(RankingCommands::remove, "remove", "rem", "delete", "del", "-");
        });
    }

    static Command.Builder<Commander> list(Command.Builder<Commander> builder) {
        Permission listPerm = Permission.pex("ranking.list");
        return builder.meta(CommandMeta.DESCRIPTION, "List information about existing rank ladders").permission(listPerm).handler(ctx -> {
            Commander source = (Commander)ctx.getSender();
            RankLadder ladder = ctx.get(LADDER_ARG);
            ArrayList<Component> ranksList = new ArrayList<Component>();
            List<SubjectRef<?>> rawRanks = ladder.ranks();
            if (rawRanks.size() == 0) {
                throw new CommandException(Messages.RANKING_ERROR_EMPTY_LADDER.tr(ladder));
            }
            if (rawRanks.size() == 1) {
                ranksList.add(source.formatter().subject(rawRanks.get(0)));
            } else {
                ListIterator<SubjectRef<?>> it = rawRanks.listIterator(rawRanks.size());
                while (it.hasPrevious()) {
                    int idx = it.previousIndex();
                    SubjectRef<?> rank = it.previous();
                    TextComponent rendered = idx == rawRanks.size() ? TextComponent.ofChildren(source.formatter().subject(rank), RankingCommands.moveDownButton(source, ladder, rank), RankingCommands.deleteButton(source, ladder, rank)) : (idx == 0 ? TextComponent.ofChildren(source.formatter().subject(rank), RankingCommands.moveUpButton(source, ladder, rank), RankingCommands.deleteButton(source, ladder, rank)) : TextComponent.ofChildren(source.formatter().subject(rank), RankingCommands.moveDownButton(source, ladder, rank), RankingCommands.moveUpButton(source, ladder, rank), RankingCommands.deleteButton(source, ladder, rank)));
                    ranksList.add(rendered);
                }
            }
            source.sendPaginated(Messages.RANKING_PAGINATION_HEADER.tr(ladder.name(), source.formatter().button(Component.text().content("+"), ButtonType.POSITIVE, Messages.RANKING_BUTTON_ADD_DESCRIPTION, "/pex rank " + ladder.name() + " add ", false)), Messages.RANKING_PAGINATION_SUBTITLE, ranksList);
        });
    }

    private static Component deleteButton(Commander cmd, RankLadder rank, SubjectRef<?> subject) {
        return cmd.formatter().button(Component.text().content("-"), ButtonType.NEGATIVE, Messages.RANKING_BUTTON_DELETE_DESCRIPTION.tr(new Object[0]), "/pex rank " + rank.name() + " remove " + subject.type().name() + " " + subject.serializedIdentifier(), true);
    }

    private static Component moveDownButton(Commander cmd, RankLadder rank, SubjectRef<?> subject) {
        return cmd.formatter().button(Component.text().content("\u25bc"), ButtonType.NEUTRAL, Messages.RANKING_BUTTON_MOVE_DOWN_DESCRIPTION.tr(new Object[0]), "/pex rank " + rank.name() + " add " + subject.type().name() + " " + subject.serializedIdentifier() + " -r -1", true);
    }

    private static Component moveUpButton(Commander cmd, RankLadder ladder, SubjectRef<?> subject) {
        return cmd.formatter().button(Component.text().content("\u25b2"), ButtonType.NEUTRAL, Messages.RANKING_BUTTON_MOVE_UP_DESCRIPTION.tr(new Object[0]), "/pex rank " + ladder.name() + " add " + subject.type().name() + " " + subject.serializedIdentifier() + " -r 1", true);
    }

    private static CommandArgument<Commander, SubjectType<?>> rankTypeArgument() {
        return CommandArgument.ofType(new TypeToken<SubjectType<?>>(){}, "type").withParser(Parsers.subjectType()).build();
    }

    private static CommandArgument<Commander, ?> rankIdentifierArgument(CommandArgument<Commander, SubjectType<?>> parentType) {
        return CommandArgument.ofType(Object.class, "identifier").withParser(Parsers.subjectIdentifier(data -> (SubjectType)data.get(parentType))).build();
    }

    static Command.Builder<Commander> add(Command.Builder<Commander> builder) {
        Permission perm = Permission.pex("rank.add");
        CommandArgument<Commander, SubjectType<?>> rankTypeArg = RankingCommands.rankTypeArgument();
        CommandArgument<Commander, ?> rankIdentifierArg = RankingCommands.rankIdentifierArgument(rankTypeArg);
        CommandArgument positionArg = IntegerArgument.optional("position");
        SubjectRefProvider rankProvider = SubjectRefProvider.of(rankTypeArg, rankIdentifierArg);
        return builder.flag(FLAG_RELATIVE).argument(rankTypeArg).argument(rankIdentifierArg).argument(positionArg).permission(perm).meta(CommandMeta.DESCRIPTION, "Add a rank to a ladder").handler(Elements.handler((source, engine, ctx) -> {
            RankLadder ladder = ctx.get(LADDER_ARG);
            source.checkPermission(perm.then(ladder.name()));
            SubjectRef<?> toAdd = rankProvider.provide(ctx);
            @Nullable Integer position = ctx.getOrDefault(positionArg, null);
            if (position != null) {
                int addPosition = position;
                if (ctx.flags().isPresent(FLAG_RELATIVE.getName())) {
                    int currentIndex = ladder.indexOf(toAdd);
                    if (currentIndex == -1) {
                        throw new CommandException(Messages.RANKING_ADD_ERROR_RELATIVE_ON_OUTSIDE_SUBJECT.tr(new Object[0]));
                    }
                    addPosition = currentIndex + addPosition > 1 ? addPosition + 1 : addPosition;
                }
                engine.ladders().set(ladder.name(), ladder.with(toAdd, addPosition)).whenComplete(Elements.messageSender(source, Messages.RANKING_ADD_SUCCESS_POSITION.tr(source.formatter().subject(toAdd), ladder.asComponent(), Component.text(addPosition))));
            } else {
                engine.ladders().set(ladder.name(), ladder.with(toAdd)).whenComplete(Elements.messageSender(source, Messages.RANKING_ADD_SUCCESS.tr(source.formatter().subject(toAdd), ladder.asComponent())));
            }
        }));
    }

    static Command.Builder<Commander> remove(Command.Builder<Commander> builder) {
        Permission perm = Permission.pex("rank.remove");
        CommandArgument<Commander, SubjectType<?>> rankTypeArg = RankingCommands.rankTypeArgument();
        CommandArgument<Commander, ?> rankIdentifierArg = RankingCommands.rankIdentifierArgument(rankTypeArg);
        SubjectRefProvider rankProvider = SubjectRefProvider.of(rankTypeArg, rankIdentifierArg);
        return builder.argument(rankTypeArg).argument(rankIdentifierArg).permission(perm).meta(CommandMeta.DESCRIPTION, "Remove a rank from a ladder").handler(Elements.handler((source, engine, ctx) -> {
            RankLadder ladder = ctx.get(LADDER_ARG);
            source.checkPermission(perm.then(ladder.name()));
            SubjectRef<?> toRemove = rankProvider.provide(ctx);
            RankLadder newLadder = ladder.without(toRemove);
            if (newLadder == ladder) {
                throw new CommandException(Messages.RANKING_REMOVE_ERROR_NOT_IN_LADDER.tr(source.formatter().subject(toRemove), ladder.asComponent()));
            }
            engine.ladders().set(ladder.name(), newLadder).whenComplete(Elements.messageSender(source, Messages.RANKING_REMOVE_SUCCESS.tr(source.formatter().subject(toRemove), ladder.asComponent())));
        }));
    }

    public static Command.Builder<Commander> promote(Command.Builder<Commander> builder) {
        Permission promote = Permission.pex("promote");
        CommandArgument<Commander, SubjectType<?>> rankTypeArg = RankingCommands.rankTypeArgument();
        CommandArgument<Commander, ?> rankIdentifierArg = RankingCommands.rankIdentifierArgument(rankTypeArg);
        CommandArgument<Commander, RankLadder> ladderArg = RankingCommands.ladderArgument(false);
        SubjectRefProvider rankProvider = SubjectRefProvider.of(rankTypeArg, rankIdentifierArg);
        return builder.flag(Elements.FLAG_TRANSIENT).flag(Elements.FLAG_CONTEXT).argument(rankTypeArg).argument(rankIdentifierArg).argument(ladderArg).meta(CommandMeta.DESCRIPTION, "Promote a subject along a rank ladder").permission(promote).handler(Elements.handler((source, engine, ctx) -> {
            RankLadder ladder = (RankLadder)ctx.get(ladderArg);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            SubjectRef.ToData<?> subject = rankProvider.provideData(ctx, promote);
            Object[] objectArray = new Object[2];
            objectArray[0] = source.formatter().subject(subject);
            objectArray[1] = ladder.asComponent().style(source.formatter()::hl);
            ((CompletableFuture)subject.update(data -> ladder.promote(contexts, (ImmutableSubjectData)data)).thenAccept(change -> {
                if (!change.changed()) {
                    throw new CommandException(Messages.PROMOTE_ERROR_ALREADY_AT_TOP.tr(source.formatter().subject(subject), ladder.asComponent()));
                }
            })).whenComplete(Elements.messageSender(source, Messages.PROMOTE_SUCCESS.tr(objectArray)));
        }));
    }

    public static Command.Builder<Commander> demote(Command.Builder<Commander> builder) {
        Permission promote = Permission.pex("demote");
        CommandArgument<Commander, SubjectType<?>> rankTypeArg = RankingCommands.rankTypeArgument();
        CommandArgument<Commander, ?> rankIdentifierArg = RankingCommands.rankIdentifierArgument(rankTypeArg);
        CommandArgument<Commander, RankLadder> ladderArg = RankingCommands.ladderArgument(false);
        SubjectRefProvider rankProvider = SubjectRefProvider.of(rankTypeArg, rankIdentifierArg);
        return builder.flag(Elements.FLAG_TRANSIENT).flag(Elements.FLAG_CONTEXT).argument(rankTypeArg).argument(rankIdentifierArg).argument(ladderArg).meta(CommandMeta.DESCRIPTION, "Demote a subject along a rank ladder").permission(promote).handler(Elements.handler((source, engine, ctx) -> {
            RankLadder ladder = (RankLadder)ctx.get(ladderArg);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            SubjectRef.ToData<?> subject = rankProvider.provideData(ctx, promote);
            Object[] objectArray = new Object[2];
            objectArray[0] = source.formatter().subject(subject);
            objectArray[1] = ladder.asComponent().style(source.formatter()::hl);
            ((CompletableFuture)subject.update(data -> ladder.promote(contexts, (ImmutableSubjectData)data)).thenAccept(change -> {
                if (!change.changed()) {
                    throw new CommandException(Messages.DEMOTE_ERROR_NOT_ON_LADDER.tr(source.formatter().subject(subject), ladder.asComponent()));
                }
            })).whenComplete(Elements.messageSender(source, Messages.DEMOTE_SUCCESS.tr(objectArray)));
        }));
    }
}

