/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;

@FunctionalInterface
interface SubjectRefProvider {
    public static SubjectRefProvider of(final CommandArgument<?, SubjectType<?>> typeArg, final CommandArgument<?, ?> identArg) {
        return new SubjectRefProvider(){

            @Override
            public <C> SubjectRef<?> provide(CommandContext<C> ctx) {
                return SubjectRef.subject((SubjectType)ctx.get(typeArg.getName()), ctx.get(identArg.getName()));
            }
        };
    }

    public <C> SubjectRef<?> provide(CommandContext<C> var1);

    default public CalculatedSubject provideCalculated(CommandContext<Commander> ctx, @Nullable Permission toCheck) {
        SubjectRef<?> ref = this.provide(ctx);
        if (toCheck != null) {
            ctx.getSender().checkPermission(toCheck.then(ref));
        }
        return ((PermissionsEngine)ctx.get("permissionsex:engine")).subject(ref).join();
    }

    default public SubjectRef.ToData<?> provideData(CommandContext<Commander> ctx, @Nullable Permission toCheck) {
        CalculatedSubject calculated = this.provideCalculated(ctx, toCheck);
        if (ctx.flags().isPresent(Elements.FLAG_TRANSIENT.getName())) {
            return calculated.transientData();
        }
        return calculated.data();
    }
}

