/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.profile;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.geantyref.TypeFactory;
import ca.stellardrift.permissionsex.minecraft.profile.GsonAdaptersMinecraftProfile;
import ca.stellardrift.permissionsex.minecraft.profile.MinecraftProfile;
import ca.stellardrift.permissionsex.minecraft.profile.ProfileApiResolver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ProfileApiResolverImpl
implements ProfileApiResolver {
    private static final String USER_AGENT = "PermissionsEx Resolver/" + ProfileApiResolver.class.getPackage().getImplementationVersion();
    private static final URL PROFILE_QUERY_URL;
    private static final int MAX_REQUEST_SIZE = 100;
    private static final Gson GSON;
    private final Executor executor;

    ProfileApiResolverImpl(Executor executor) {
        this.executor = executor;
    }

    private HttpURLConnection openConnection(URL endpoint) throws IOException {
        URLConnection conn = endpoint.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IllegalStateException("Profile connection should be a HttpURLConnection but isn't");
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.connect();
        return (HttpURLConnection)conn;
    }

    @Override
    public Stream<MinecraftProfile> resolveByName(Iterable<String> names) {
        Iterable<Set<String>> batchedNames = ProfileApiResolverImpl.batchedAndFiltered(names, 100, it -> it.length() <= 16);
        HashSet requests = new HashSet();
        for (Set<String> batch : batchedNames) {
            requests.add(this.sendProfileRequest(batch));
        }
        return ProfileApiResolverImpl.unwrapToStream(requests).flatMap(Collection::stream);
    }

    private static <T> Iterable<Set<T>> batchedAndFiltered(final Iterable<T> input, final int batchSize, final Predicate<T> filter) {
        return () -> new Iterator<Set<T>>(){
            final Iterator base;
            {
                this.base = input.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public Set<T> next() {
                if (!this.base.hasNext()) {
                    throw new NoSuchElementException();
                }
                HashSet out = new HashSet();
                int counter = 0;
                while (this.base.hasNext() && counter < batchSize) {
                    Object next = this.base.next();
                    if (!filter.test(next)) continue;
                    ++counter;
                    out.add(next);
                }
                return out;
            }
        };
    }

    private CompletableFuture<List<MinecraftProfile>> sendProfileRequest(Set<String> names) {
        CompletableFuture<List<MinecraftProfile>> result = new CompletableFuture<List<MinecraftProfile>>();
        if (names.isEmpty()) {
            result.complete(Collections.emptyList());
            return result;
        }
        this.executor.execute(() -> {
            try {
                InputStreamReader is;
                JsonWriter json;
                HttpURLConnection conn = this.openConnection(PROFILE_QUERY_URL);
                try (OutputStreamWriter os = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                    json = GSON.newJsonWriter((Writer)os);
                    try {
                        json.beginArray();
                        for (String name : names) {
                            json.value(name);
                        }
                        json.endArray();
                    }
                    finally {
                        if (json != null) {
                            json.close();
                        }
                    }
                }
                if (conn.getResponseCode() != 200) {
                    is = new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8);
                    try {
                        json = (JsonObject)GSON.fromJson((Reader)is, JsonObject.class);
                        result.completeExceptionally(new IOException(json.toString()));
                        return;
                    }
                    finally {
                        is.close();
                    }
                }
                is = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
                try {
                    result.complete((List)GSON.fromJson((Reader)is, TypeFactory.parameterizedClass(List.class, new Type[]{MinecraftProfile.class})));
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    private static <T> Stream<T> unwrapToStream(Collection<CompletableFuture<T>> futures) {
        return StreamSupport.stream(new MappingSpliterator(futures.spliterator()), false);
    }

    static {
        try {
            PROFILE_QUERY_URL = new URL("https://api.mojang.com/profiles/minecraft");
        }
        catch (MalformedURLException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new TypeAdapter<UUID>(){

            public void write(JsonWriter out, UUID value) throws IOException {
                out.jsonValue(value.toString().replace("-", ""));
            }

            public UUID read(JsonReader in) throws IOException {
                String mojangId = in.nextString();
                StringBuilder result = new StringBuilder(36).append(mojangId, 0, 8).append("-").append(mojangId, 8, 12).append("-").append(mojangId, 12, 16).append("-").append(mojangId, 16, 20).append("-").append(mojangId, 20, 32);
                return UUID.fromString(result.toString());
            }
        }.nullSafe()).registerTypeAdapterFactory((TypeAdapterFactory)new GsonAdaptersMinecraftProfile()).create();
    }

    private static class MappingSpliterator<V>
    implements Spliterator<V> {
        private final Spliterator<CompletableFuture<V>> base;

        private MappingSpliterator(Spliterator<CompletableFuture<V>> base) {
            this.base = base;
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            return this.base.tryAdvance((? super T future) -> action.accept((Object)future.join()));
        }

        @Override
        public @Nullable Spliterator<V> trySplit() {
            @Nullable Spliterator<CompletableFuture<V>> base = this.base.trySplit();
            return base == null ? null : new MappingSpliterator<V>(base);
        }

        @Override
        public long estimateSize() {
            return this.base.estimateSize();
        }

        @Override
        public int characteristics() {
            return (this.base.characteristics() | 0x400) & 0xFFFFFFFE;
        }
    }
}

