/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.sql.hikari;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.hikari.HikariConfig;
import ca.stellardrift.permissionsex.ext.hikari.HikariDataSource;
import ca.stellardrift.permissionsex.ext.pcollections.HashPMap;
import ca.stellardrift.permissionsex.ext.pcollections.HashTreePMap;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.engine.ConnectionInfo;

public class Hikari {
    private static final Pattern JDBC_URL_REGEX = Pattern.compile("(?:jdbc:)?([^:]+):(//)?(?:([^:]+)(?::([^@]+))?@)?(.*)");
    private static final PMap<String, BiFunction<Path, String, String>> PATH_CANONICALIZERS = HashTreePMap.singleton("h2", (baseDir, orig) -> {
        Path origPath;
        ConnectionInfo h2Info = new ConnectionInfo(orig);
        if (!h2Info.isPersistent() || h2Info.isRemote()) {
            return orig;
        }
        String url = orig;
        if (url.startsWith("file:")) {
            url = orig.substring("file:".length());
        }
        if ((origPath = Paths.get(url, new String[0])).isAbsolute()) {
            return origPath.toString();
        }
        return baseDir.toAbsolutePath().resolve(origPath).toString().replace('\\', '/');
    });
    private static final PMap<String, Properties> PROTOCOL_SPECIFIC_PROPS;

    public static HikariDataSource createDataSource(String jdbcUrl) throws SQLException {
        return Hikari.createDataSource(jdbcUrl, Paths.get(".", new String[0]));
    }

    public static HikariDataSource createDataSource(String jdbcUrl, Path baseDir) throws SQLException {
        Matcher match = JDBC_URL_REGEX.matcher(Objects.requireNonNull(jdbcUrl, "jdbcUrl"));
        if (!match.matches()) {
            throw new IllegalArgumentException("URL " + jdbcUrl + " is not a valid JDBC URL");
        }
        String protocol = match.group(1);
        boolean hasSlashes = match.group(2) != null;
        @Nullable String user = match.group(3);
        @Nullable String pass = match.group(4);
        String serverDatabaseSpecifier = match.group(5);
        BiFunction derelativizer = (BiFunction)PATH_CANONICALIZERS.get(protocol);
        if (derelativizer != null) {
            serverDatabaseSpecifier = (String)derelativizer.apply(baseDir, serverDatabaseSpecifier);
        }
        String unauthedUrl = "jdbc:" + protocol + (hasSlashes ? "://" : ":") + serverDatabaseSpecifier;
        String driverClass = DriverManager.getDriver(unauthedUrl).getClass().getCanonicalName();
        HikariConfig config = new HikariConfig();
        config.setUsername(user);
        config.setPassword(pass);
        config.setDriverClassName(driverClass);
        config.setMaximumPoolSize(Runtime.getRuntime().availableProcessors() * 2 + 1);
        @Nullable Properties driverSpecificProperties = (Properties)PROTOCOL_SPECIFIC_PROPS.get(driverClass);
        Properties dsProps = driverSpecificProperties == null ? new Properties() : new Properties(driverSpecificProperties);
        dsProps.setProperty("baseDir", baseDir.toAbsolutePath().toString());
        config.setDataSourceProperties(dsProps);
        config.setJdbcUrl(unauthedUrl);
        return new HikariDataSource(config);
    }

    private Hikari() {
    }

    static {
        Properties mysqlProps = new Properties();
        mysqlProps.setProperty("useConfigs", "maxPerformance");
        PROTOCOL_SPECIFIC_PROPS = ((HashPMap)HashTreePMap.empty().plus("com.mysql.jdbc.Driver", mysqlProps)).plus("org.maridadb.jdbc.Driver", mysqlProps);
    }
}

