/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.util.glob.GlobNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

final class CharsNode
extends GlobNode {
    private final String[] characters;

    CharsNode(String characters) {
        this.characters = (String[])Objects.requireNonNull(characters, "characters").codePoints().mapToObj(cp -> String.valueOf(Character.toChars(cp))).toArray(String[]::new);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CharsNode.this.characters.length;
            }

            @Override
            public String next() {
                return CharsNode.this.characters[this.index++];
            }
        };
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        for (String character : this.characters) {
            action.accept(character);
        }
    }

    @Override
    public Spliterator<String> spliterator() {
        return Arrays.spliterator(this.characters);
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.characters);
    }

    public boolean equals(Object obj) {
        return obj instanceof CharsNode && Arrays.equals(((CharsNode)obj).characters, this.characters);
    }

    public String toString() {
        return "CharsNode{" + Arrays.toString(this.characters) + '}';
    }
}

