/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.BailErrorStrategy;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.CharStream;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.CharStreams;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.CommonTokenStream;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.RecognitionException;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.Token;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.misc.ParseCancellationException;
import ca.stellardrift.permissionsex.util.glob.CharsNode;
import ca.stellardrift.permissionsex.util.glob.GlobNode;
import ca.stellardrift.permissionsex.util.glob.GlobParseException;
import ca.stellardrift.permissionsex.util.glob.GlobVisitor;
import ca.stellardrift.permissionsex.util.glob.OrNode;
import ca.stellardrift.permissionsex.util.glob.SequenceNode;
import ca.stellardrift.permissionsex.util.glob.UnitNode;
import ca.stellardrift.permissionsex.util.glob.parser.GlobLexer;
import ca.stellardrift.permissionsex.util.glob.parser.GlobParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Globs {
    private Globs() {
    }

    public static GlobNode or(Object ... ors) {
        return new OrNode(Globs.parseValues(ors));
    }

    public static GlobNode seq(Object ... elements) {
        return new SequenceNode(Globs.parseValues(elements));
    }

    public static GlobNode literal(String value) {
        return new UnitNode(value);
    }

    public static GlobNode chars(String characters) {
        return new CharsNode(characters);
    }

    public static GlobNode parse(String input) throws GlobParseException {
        if (!input.contains("{") && !input.contains("[")) {
            return new UnitNode(input);
        }
        return Globs.parse0(CharStreams.fromString(input));
    }

    private static GlobNode parse0(CharStream input) throws GlobParseException {
        GlobLexer lexer = new GlobLexer(input);
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        GlobParser parser = new GlobParser(tokenStream);
        parser.getErrorListeners().clear();
        parser.setErrorHandler(new BailErrorStrategy());
        try {
            return (GlobNode)GlobVisitor.INSTANCE.visit(parser.rootGlob());
        }
        catch (ParseCancellationException e) {
            RecognitionException ex = (RecognitionException)e.getCause();
            Token errorToken = ex.getOffendingToken();
            throw new GlobParseException(Globs.parseErrorMessage(errorToken.getText(), errorToken.getLine(), errorToken.getCharPositionInLine()), ex);
        }
    }

    private static String parseErrorMessage(String text, int line, int column) {
        return "Unable to parse glob: Error at token " + text + " (at position " + line + ":" + column + ")";
    }

    private static List<GlobNode> parseValues(Object[] values) {
        ArrayList<GlobNode> vals = new ArrayList<GlobNode>(values.length);
        for (Object value : values) {
            if (value instanceof GlobNode) {
                vals.add((GlobNode)value);
                continue;
            }
            vals.add(Globs.literal(String.valueOf(value)));
        }
        return Collections.unmodifiableList(vals);
    }
}

