/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.util.glob.GlobNode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

final class OrNode
extends GlobNode {
    private final List<GlobNode> children;

    OrNode(List<GlobNode> children) {
        this.children = children;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final Iterator<GlobNode> children;
            private @Nullable Iterator<String> child;
            {
                this.children = OrNode.this.children.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.child != null && this.child.hasNext()) {
                    return true;
                }
                return this.children.hasNext();
            }

            @Override
            public String next() {
                while (this.child == null) {
                    this.child = this.children.next().iterator();
                    if (this.child.hasNext()) continue;
                    this.child = null;
                }
                String result = this.child.next();
                if (!this.child.hasNext()) {
                    this.child = null;
                }
                return result;
            }
        };
    }

    public String toString() {
        return "or(" + this.children + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrNode)) {
            return false;
        }
        OrNode that = (OrNode)other;
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hashCode(this.children);
    }
}

