/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BukkitCommander
implements Commander {
    private final PermissionsExPlugin plugin;
    private final CommandSender source;
    private final Audience audience;

    BukkitCommander(PermissionsExPlugin plugin, CommandSender source) {
        this.plugin = plugin;
        this.source = source;
        this.audience = plugin.adventure().sender(source);
    }

    public Component name() {
        return Component.text((String)this.source.getName());
    }

    public @Nullable SubjectRef<?> subjectIdentifier() {
        if (this.source instanceof Player) {
            return SubjectRef.subject((SubjectType)this.plugin.users().type(), (Object)((Player)this.source).getUniqueId());
        }
        return null;
    }

    public MessageFormatter formatter() {
        return this.plugin.manager().messageFormatter();
    }

    public boolean hasPermission(String permission) {
        return this.source.hasPermission(permission);
    }

    public @NonNull Audience audience() {
        return this.audience;
    }

    CommandSender source() {
        return this.source;
    }
}

