/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.EnumContextDefinition;
import ca.stellardrift.permissionsex.context.SimpleContextDefinition;
import ca.stellardrift.permissionsex.impl.context.IpSetContextDefinition;
import ca.stellardrift.permissionsex.impl.util.IpSet;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BukkitContexts {
    public static ContextDefinition<String> world() {
        return WorldDefinition.INSTANCE;
    }

    public static ContextDefinition<World.Environment> dimension() {
        return DimensionType.INSTANCE;
    }

    public static ContextDefinition<IpSet> remoteIp() {
        return RemoteIp.INSTANCE;
    }

    public static ContextDefinition<String> localHost() {
        return LocalHost.INSTANCE;
    }

    public static ContextDefinition<IpSet> localIp() {
        return LocalIp.INSTANCE;
    }

    public static ContextDefinition<Integer> localPort() {
        return LocalPort.INSTANCE;
    }

    static final class LocalPort
    extends ContextDefinition<Integer> {
        static final LocalPort INSTANCE = new LocalPort();

        private LocalPort() {
            super("localport");
        }

        public String serialize(Integer canonicalValue) {
            return canonicalValue.toString();
        }

        public @Nullable Integer deserialize(String userValue) {
            try {
                return Integer.parseInt(userValue);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }

        public boolean matches(Integer ownVal, Integer testVal) {
            return Objects.equals(ownVal, testVal);
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<Integer> consumer) {
            consumer.accept(Bukkit.getPort());
        }
    }

    static final class LocalIp
    extends IpSetContextDefinition {
        static final LocalIp INSTANCE = new LocalIp();

        private LocalIp() {
            super("localip");
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<IpSet> consumer) {
        }
    }

    static final class LocalHost
    extends SimpleContextDefinition {
        static final LocalHost INSTANCE = new LocalHost();

        private LocalHost() {
            super("localhost");
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<String> consumer) {
            @Nullable String host = (String)subject.transientData().get().segment(ContextDefinitionProvider.GLOBAL_CONTEXT).options().get("hostname");
            if (host != null) {
                consumer.accept(host);
            }
        }
    }

    static final class RemoteIp
    extends IpSetContextDefinition {
        static final RemoteIp INSTANCE = new RemoteIp();

        private RemoteIp() {
            super("remoteip");
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<IpSet> consumer) {
            InetSocketAddress address;
            @Nullable Object associated = subject.associatedObject();
            if (associated instanceof Player && (address = ((Player)associated).getAddress()) != null) {
                consumer.accept(IpSet.only((InetAddress)address.getAddress()));
            }
        }
    }

    static final class DimensionType
    extends EnumContextDefinition<World.Environment> {
        static final DimensionType INSTANCE = new DimensionType();

        private DimensionType() {
            super("dimension", World.Environment.class);
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<World.Environment> consumer) {
            @Nullable Object associated = subject.associatedObject();
            if (associated instanceof Player) {
                consumer.accept(((Player)associated).getWorld().getEnvironment());
            }
        }
    }

    static class WorldDefinition
    extends SimpleContextDefinition {
        static final WorldDefinition INSTANCE = new WorldDefinition();

        private WorldDefinition() {
            super("world");
        }

        public boolean matches(String ownVal, String testVal) {
            return ownVal.equalsIgnoreCase(testVal);
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<String> consumer) {
            @Nullable Object associated = subject.associatedObject();
            if (associated instanceof Player) {
                consumer.accept(((Player)associated).getWorld().getName());
            }
        }

        public Set<String> suggestValues(CalculatedSubject subject) {
            return PCollections.asSet((Iterable)Bukkit.getWorlds(), World::getName);
        }
    }
}

