/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.bukkit.BukkitConfiguration;
import ca.stellardrift.permissionsex.bukkit.Messages;
import ca.stellardrift.permissionsex.bukkit.PEXPermissionAttachment;
import ca.stellardrift.permissionsex.bukkit.PermissionList;
import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.context.TimeContextDefinition;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.util.NodeTree;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.permissions.PermissionRemovedExecutor;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PEXPermissible
extends PermissibleBase {
    private final Player player;
    private final PermissionsExPlugin plugin;
    private final PermissionsEngine engine;
    @Nullable Permissible previousPermissible;
    private final Set<PEXPermissionAttachment> attachments = ConcurrentHashMap.newKeySet();
    private final CalculatedSubject pexSubject;
    private static final Metapermission[] METAPERMISSIONS = new Metapermission[]{new Metapermission(Pattern.compile("groups?\\.(.+)")){

        @Override
        boolean isMatch(PermissionsExPlugin plugin, MatchResult result, CalculatedSubject subj, Set<ContextValue<?>> contexts) {
            return subj.parents(contexts).contains(SubjectRef.subject(plugin.groups(), (Object)result.group(1)));
        }

        @Override
        Stream<String> getValues(PermissionsExPlugin plugin, CalculatedSubject subj, Set<ContextValue<?>> contexts) {
            return subj.parents(contexts).stream().filter(ref -> ref.type().equals((Object)plugin.groups().type())).flatMap(ref -> Stream.of("group." + ref.serializedIdentifier(), "groups." + ref.serializedIdentifier()));
        }
    }, new Metapermission(Pattern.compile("options\\.(.*)\\.(.*)")){

        @Override
        boolean isMatch(PermissionsExPlugin plugin, MatchResult result, CalculatedSubject subject, Set<ContextValue<?>> contexts) {
            return subject.option(contexts, result.group(1)).map(it -> it.equals(result.group(2))).orElse(false);
        }

        @Override
        Stream<String> getValues(PermissionsExPlugin plugin, CalculatedSubject subj, Set<ContextValue<?>> contexts) {
            return subj.options(contexts).entrySet().stream().map(ent -> "options." + (String)ent.getKey() + "." + (String)ent.getValue());
        }
    }, new SpecificOptionMetapermission("prefix"), new SpecificOptionMetapermission("suffix")};

    PEXPermissible(Player player, PermissionsExPlugin plugin) {
        super((ServerOperator)player);
        this.player = player;
        this.plugin = plugin;
        this.engine = plugin.engine();
        this.pexSubject = (CalculatedSubject)plugin.users().get((Object)player.getUniqueId()).join();
    }

    PermissionsEngine manager() {
        return this.engine;
    }

    public boolean isPermissionSet(String name) {
        return this.getPermissionValue(this.pexSubject.activeContexts(), name.toLowerCase(Locale.ROOT)) != 0;
    }

    private int getPermissionValue(Set<ContextValue<?>> contexts, String permission) {
        int ret = this.getPermissionValue0(this.pexSubject.permissions(contexts), permission);
        if (ret == 0) {
            for (Metapermission meta : METAPERMISSIONS) {
                Matcher match = meta.matchAgainst.matcher(permission);
                if (!match.matches() || !meta.isMatch(this.plugin, match, this.pexSubject, contexts)) continue;
                ret = 1;
            }
        }
        if (ret == 0 && ((BukkitConfiguration)this.plugin.manager().platformConfig()).fallbackOp()) {
            Permission perm = (Permission)this.plugin.permissionList().get(permission);
            if (perm == null) {
                ret = this.isOp() ? 1 : 0;
            } else if (perm.getDefault() != PermissionDefault.FALSE) {
                int n = ret = this.isOp() ^ perm.getDefault() == PermissionDefault.NOT_OP ? 1 : 0;
            }
        }
        if (this.engine.debugMode()) {
            this.plugin.logger().info((Component)Messages.SUPERPERMS_CHECK_NOTIFY.tr(new Object[]{permission, this.player.getName(), contexts, ret}));
        }
        return ret;
    }

    private int getPermissionValue0(NodeTree nodeTree, String name) {
        int result = nodeTree.get(name);
        if (result != 0) {
            return result;
        }
        @Nullable PermissionList list = this.plugin.permissionList();
        if (list != null) {
            for (Map.Entry<String, Boolean> entry : list.getParents(name)) {
                result = this.getPermissionValue0(nodeTree, entry.getKey());
                if (!entry.getValue().booleanValue()) {
                    result = -result;
                }
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    public boolean isPermissionSet(Permission perm) {
        return this.isPermissionSet(perm.getName());
    }

    public boolean hasPermission(String perm) {
        return this.getPermissionValue(this.pexSubject.activeContexts(), perm.toLowerCase(Locale.ROOT)) > 0;
    }

    public boolean hasPermission(Permission perm) {
        return this.hasPermission(perm.getName());
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return super.addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        PEXPermissionAttachment attach = new PEXPermissionAttachment(plugin, this.player, this);
        this.pexSubject.transientData().update(ContextDefinitionProvider.GLOBAL_CONTEXT, it -> it.plusParent((SubjectRef)attach)).thenRun(() -> this.attachments.add(attach));
        return attach;
    }

    boolean removeAttachmentInternal(PEXPermissionAttachment attach) {
        this.pexSubject.transientData().update(ContextDefinitionProvider.GLOBAL_CONTEXT, it -> it.minusParent((SubjectRef)attach)).thenRun(() -> {
            @Nullable PermissionRemovedExecutor callback = attach.getRemovalCallback();
            if (callback != null) {
                callback.attachmentRemoved((PermissionAttachment)attach);
            }
        });
        return true;
    }

    public void removeAttachment(PermissionAttachment attachment) {
        if (!(attachment instanceof PEXPermissionAttachment)) {
            throw new IllegalArgumentException("Provided attachment was not a PEX attachment!");
        }
        this.removeAttachmentInternal((PEXPermissionAttachment)attachment);
        this.attachments.remove(attachment);
    }

    void removeAllAttachments() {
        for (PEXPermissionAttachment attachment : this.attachments) {
            this.removeAttachmentInternal(attachment);
        }
        this.attachments.clear();
    }

    public void recalculatePermissions() {
    }

    public void clearPermissions() {
    }

    public @Nullable PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return super.addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        PEXPermissionAttachment attach = new PEXPermissionAttachment((Plugin)this.plugin, this.player, this);
        this.pexSubject.transientData().update((Set)PCollections.set((Object)TimeContextDefinition.BEFORE_TIME.createValue((Object)ZonedDateTime.now(ZoneId.systemDefault()).plus((long)ticks * 50L, ChronoUnit.MILLIS))), it -> it.plusParent((SubjectRef)attach)).thenRun(() -> this.attachments.add(attach));
        return attach;
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        Set activeContexts = this.pexSubject.activeContexts();
        Stream<PermissionAttachmentInfo> direct = this.pexSubject.permissions(activeContexts).asMap().entrySet().stream().map(ent -> new PermissionAttachmentInfo((Permissible)this.player, (String)ent.getKey(), null, (Integer)ent.getValue() > 0));
        Stream<PermissionAttachmentInfo> metapermissions = Arrays.stream(METAPERMISSIONS).flatMap(mPerm -> mPerm.getValues(this.plugin, this.pexSubject, activeContexts)).map(value -> new PermissionAttachmentInfo((Permissible)this.player, value, null, true));
        return Stream.concat(direct, metapermissions).collect(Collectors.toSet());
    }

    static final class SpecificOptionMetapermission
    extends Metapermission {
        private final String option;

        SpecificOptionMetapermission(String option) {
            super(Pattern.compile(Pattern.quote(option) + "\\.(.+)"));
            this.option = option;
        }

        @Override
        boolean isMatch(PermissionsExPlugin plugin, MatchResult result, CalculatedSubject subject, Set<ContextValue<?>> contexts) {
            return subject.option(contexts, this.option).map(it -> it.equals(result.group(1))).orElse(false);
        }

        @Override
        Stream<String> getValues(PermissionsExPlugin plugin, CalculatedSubject subj, Set<ContextValue<?>> contexts) {
            String ret = (String)subj.options(contexts).get(this.option);
            return ret == null ? Stream.of(new String[0]) : Stream.of(this.option + "." + ret);
        }
    }

    static abstract class Metapermission {
        protected final Pattern matchAgainst;

        protected Metapermission(Pattern matchAgainst) {
            this.matchAgainst = matchAgainst;
        }

        abstract boolean isMatch(PermissionsExPlugin var1, MatchResult var2, CalculatedSubject var3, Set<ContextValue<?>> var4);

        abstract Stream<String> getValues(PermissionsExPlugin var1, CalculatedSubject var2, Set<ContextValue<?>> var3);
    }
}

