/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.BukkitConfiguration;
import ca.stellardrift.permissionsex.bukkit.BukkitContexts;
import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Objects;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PEXVault
extends Permission {
    final PermissionsExPlugin pex;

    PEXVault(PermissionsExPlugin pex) {
        this.pex = pex;
        this.plugin = pex;
    }

    public String getName() {
        return this.pex.getName();
    }

    public boolean isEnabled() {
        return this.pex.isEnabled();
    }

    public boolean hasSuperPermsCompat() {
        return true;
    }

    public boolean hasGroupSupport() {
        return true;
    }

    public String[] getGroups() {
        return (String[])this.pex.groups().allIdentifiers().toArray(String[]::new);
    }

    CalculatedSubject getGroup(String name) {
        return (CalculatedSubject)this.pex.groups().get((Object)name).join();
    }

    CalculatedSubject getUser(OfflinePlayer player) {
        return (CalculatedSubject)this.pex.users().get((Object)player.getUniqueId()).join();
    }

    Set<ContextValue<?>> contextsFrom(@Nullable String world) {
        if (world == null) {
            return ContextDefinitionProvider.GLOBAL_CONTEXT;
        }
        return PCollections.set((Object)BukkitContexts.world().createValue((Object)world));
    }

    public @Nullable String getActiveWorld(OfflinePlayer player) {
        @Nullable Player ply = player.getPlayer();
        return ply == null ? null : ply.getWorld().getName();
    }

    Set<ContextValue<?>> contextsFrom(CalculatedSubject subject, @Nullable String worldOverride) {
        Set origContexts = subject.activeContexts();
        if (worldOverride == null) {
            return origContexts;
        }
        @Nullable Object associated = subject.associatedObject();
        if (associated instanceof Player && ((Player)associated).getWorld().getName().equalsIgnoreCase(worldOverride)) {
            return origContexts;
        }
        origContexts.removeIf(it -> BukkitContexts.world().equals((Object)it.definition()));
        origContexts.add(BukkitContexts.world().createValue((Object)worldOverride));
        return origContexts;
    }

    public boolean groupHas(@Nullable String world, String name, String permission) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(permission, "permission");
        CalculatedSubject subject = this.getGroup(name);
        return subject.permission(this.contextsFrom(subject, world), permission) > 0;
    }

    public boolean groupAdd(@Nullable String world, String name, String permission) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(permission, "permission");
        return !this.getGroup(name).data().update(this.contextsFrom(world), it -> it.withPermission(permission, 1)).isCancelled();
    }

    public boolean groupRemove(@Nullable String world, String name, String permission) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(permission, "permission");
        return !this.getGroup(name).data().update(this.contextsFrom(world), it -> it.withPermission(permission, 0)).isCancelled();
    }

    public boolean playerHas(@Nullable String world, OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        CalculatedSubject subj = this.getUser(player);
        int value = subj.permission(this.contextsFrom(subj, world), permission);
        if (value > 0) {
            return true;
        }
        if (value < 0) {
            return false;
        }
        return ((BukkitConfiguration)this.pex.manager().platformConfig()).fallbackOp() && player.isOp();
    }

    public boolean playerAdd(@Nullable String world, OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        return !this.getUser(player).data().update(this.contextsFrom(world), it -> it.withPermission(permission, 1)).isCancelled();
    }

    public boolean playerAddTransient(OfflinePlayer player, String permission) {
        return this.playerAddTransient(this.getActiveWorld(player), player, permission);
    }

    public boolean playerAddTransient(Player player, String permission) {
        return this.playerAddTransient(player.getWorld().getName(), player, permission);
    }

    public boolean playerAddTransient(@Nullable String worldName, OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        return !this.getUser(player).transientData().update(this.contextsFrom(worldName), it -> it.withPermission(permission, 1)).isCancelled();
    }

    public boolean playerRemoveTransient(@Nullable String worldName, OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        return !this.getUser(player).transientData().update(this.contextsFrom(worldName), it -> it.withPermission(permission, 0)).isCancelled();
    }

    public boolean playerRemove(@Nullable String world, OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        return !this.getUser(player).data().update(this.contextsFrom(world), it -> it.withPermission(permission, 0)).isCancelled();
    }

    public boolean playerRemoveTransient(Player player, String permission) {
        return this.playerRemoveTransient(player.getWorld().getName(), player, permission);
    }

    public boolean playerRemoveTransient(OfflinePlayer player, String permission) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(permission, "permission");
        return this.playerRemoveTransient(this.getActiveWorld(player), player, permission);
    }

    public boolean playerInGroup(@Nullable String world, OfflinePlayer player, String group) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(group, "group");
        CalculatedSubject subject = this.getUser(player);
        return subject.parents(this.contextsFrom(subject, world)).contains(SubjectRef.subject(this.pex.groups(), (Object)group));
    }

    public boolean playerAddGroup(@Nullable String world, OfflinePlayer player, String group) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(group, "group");
        return !this.getUser(player).data().update(this.contextsFrom(world), it -> it.plusParent(this.pex.groups().type(), (Object)group)).isCancelled();
    }

    public boolean playerRemoveGroup(@Nullable String world, OfflinePlayer player, String group) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(group, "group");
        return !this.getUser(player).data().update(this.contextsFrom(world), it -> it.minusParent(this.pex.groups().type(), (Object)group)).isCancelled();
    }

    public String[] getPlayerGroups(@Nullable String world, OfflinePlayer player) {
        Objects.requireNonNull(player, "player");
        CalculatedSubject subj = this.getUser(player);
        SubjectType groups = this.pex.groups().type();
        return (String[])subj.parents(this.contextsFrom(subj, world)).stream().filter(ref -> ref.type().equals((Object)groups)).map(SubjectRef::serializedIdentifier).toArray(String[]::new);
    }

    public @Nullable String getPrimaryGroup(@Nullable String world, OfflinePlayer player) {
        Objects.requireNonNull(player, "player");
        String[] groups = this.getPlayerGroups(world, player);
        return groups.length > 0 ? groups[0] : null;
    }

    private OfflinePlayer pFromName(String name) {
        return this.pex.getServer().getOfflinePlayer(name);
    }

    @Deprecated
    public boolean playerHas(@Nullable String world, String name, String permission) {
        return this.playerHas(world, this.pFromName(name), permission);
    }

    @Deprecated
    public boolean playerAdd(@Nullable String world, String name, String permission) {
        return this.playerAdd(world, this.pFromName(name), permission);
    }

    @Deprecated
    public boolean playerRemove(@Nullable String world, String name, String permission) {
        return this.playerRemove(world, this.pFromName(name), permission);
    }

    @Deprecated
    public boolean playerInGroup(@Nullable String world, String player, String group) {
        return this.playerInGroup(world, this.pFromName(player), group);
    }

    @Deprecated
    public boolean playerAddGroup(@Nullable String world, String player, String group) {
        return this.playerAddGroup(world, this.pFromName(player), group);
    }

    @Deprecated
    public boolean playerRemoveGroup(@Nullable String world, String player, String group) {
        return this.playerRemoveGroup(world, this.pFromName(player), group);
    }

    @Deprecated
    public String[] getPlayerGroups(@Nullable String world, String player) {
        return this.getPlayerGroups(world, this.pFromName(player));
    }

    @Deprecated
    public @Nullable String getPrimaryGroup(String world, String player) {
        return this.getPrimaryGroup(world, this.pFromName(player));
    }
}

