/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.PEXVault;
import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.util.Objects;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PEXVaultChat
extends Chat {
    private static final String OPTION_PREFIX = "prefix";
    private static final String OPTION_SUFFIX = "suffix";
    private final PEXVault perms;

    PEXVaultChat(PEXVault permissions) {
        super((Permission)permissions);
        this.perms = permissions;
    }

    private PermissionsExPlugin plugin() {
        return this.perms.pex;
    }

    public String getName() {
        return this.plugin().getName();
    }

    public boolean isEnabled() {
        return this.plugin().isEnabled();
    }

    public @Nullable String getGroupInfoString(@Nullable String world, String name, String key, @Nullable String defaultValue) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(key, "key");
        CalculatedSubject subj = this.perms.getGroup(name);
        return subj.option(this.perms.contextsFrom(subj, world), key).orElse(defaultValue);
    }

    public void setGroupInfoString(@Nullable String world, String name, String key, @Nullable String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(key, "key");
        this.perms.getGroup(name).data().update(this.perms.contextsFrom(world), it -> value == null ? it.withoutOption(key) : it.withOption(key, value));
    }

    public @Nullable String getPlayerInfoString(@Nullable String world, OfflinePlayer player, String node, @Nullable String defaultValue) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(node, "node");
        CalculatedSubject subj = this.perms.getUser(player);
        return subj.option(this.perms.contextsFrom(subj, world), node).orElse(defaultValue);
    }

    public void setPlayerInfoString(@Nullable String world, OfflinePlayer player, String node, @Nullable String value) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(node, "node");
        this.perms.getUser(player).data().update(this.perms.contextsFrom(world), it -> value == null ? it.withoutOption(node) : it.withOption(node, value));
    }

    public @Nullable String getGroupPrefix(@Nullable String world, String name) {
        return this.getGroupInfoString(world, name, OPTION_PREFIX, null);
    }

    public void setGroupPrefix(@Nullable String world, String name, String prefix) {
        this.setGroupInfoString(world, name, OPTION_PREFIX, prefix);
    }

    public @Nullable String getGroupSuffix(@Nullable String world, String name) {
        return this.getGroupInfoString(world, name, OPTION_SUFFIX, null);
    }

    public void setGroupSuffix(@Nullable String world, String name, String suffix) {
        this.setGroupInfoString(world, name, OPTION_SUFFIX, suffix);
    }

    public int getGroupInfoInteger(@Nullable String world, String name, String node, int defaultValue) {
        try {
            @Nullable String plain = this.getGroupInfoString(world, name, node, null);
            return plain == null ? defaultValue : Integer.parseInt(plain);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setGroupInfoInteger(@Nullable String world, String name, String node, int value) {
        this.setGroupInfoString(world, name, node, Integer.toString(value));
    }

    public double getGroupInfoDouble(@Nullable String world, String name, String node, double defaultValue) {
        try {
            @Nullable String plain = this.getGroupInfoString(world, name, node, null);
            return plain == null ? defaultValue : Double.parseDouble(plain);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setGroupInfoDouble(@Nullable String world, String name, String node, double value) {
        this.setGroupInfoString(world, name, node, Double.toString(value));
    }

    public boolean getGroupInfoBoolean(@Nullable String world, String name, String node, boolean defaultValue) {
        @Nullable String plain = this.getGroupInfoString(world, name, node, null);
        return plain == null ? defaultValue : Boolean.parseBoolean(plain);
    }

    public void setGroupInfoBoolean(@Nullable String world, String name, String node, boolean value) {
        this.setGroupInfoString(world, name, node, Boolean.toString(value));
    }

    public @Nullable String getPlayerPrefix(@Nullable String world, OfflinePlayer player) {
        return this.getPlayerInfoString(world, player, OPTION_PREFIX, null);
    }

    public void setPlayerPrefix(@Nullable String world, OfflinePlayer player, String prefix) {
        this.setPlayerInfoString(world, player, OPTION_PREFIX, prefix);
    }

    public @Nullable String getPlayerSuffix(@Nullable String world, OfflinePlayer player) {
        return this.getPlayerInfoString(world, player, OPTION_SUFFIX, null);
    }

    public void setPlayerSuffix(@Nullable String world, OfflinePlayer player, String suffix) {
        this.setPlayerInfoString(world, player, OPTION_SUFFIX, suffix);
    }

    public int getPlayerInfoInteger(@Nullable String world, OfflinePlayer player, String node, int defaultValue) {
        try {
            @Nullable String plain = this.getPlayerInfoString(world, player, node, null);
            return plain == null ? defaultValue : Integer.parseInt(plain);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setPlayerInfoInteger(@Nullable String world, OfflinePlayer player, String node, int value) {
        this.setPlayerInfoString(world, player, node, Integer.toString(value));
    }

    public double getPlayerInfoDouble(@Nullable String world, OfflinePlayer player, String node, double defaultValue) {
        try {
            @Nullable String plain = this.getPlayerInfoString(world, player, node, null);
            return plain == null ? defaultValue : Double.parseDouble(plain);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setPlayerInfoDouble(@Nullable String world, OfflinePlayer player, String node, double value) {
        this.setPlayerInfoString(world, player, node, Double.toString(value));
    }

    public boolean getPlayerInfoBoolean(@Nullable String world, OfflinePlayer player, String node, boolean defaultValue) {
        @Nullable String plain = this.getPlayerInfoString(world, player, node, null);
        return plain == null ? defaultValue : Boolean.parseBoolean(plain);
    }

    public void setPlayerInfoBoolean(@Nullable String world, OfflinePlayer player, String node, boolean value) {
        this.setPlayerInfoString(world, player, node, Boolean.toString(value));
    }

    private OfflinePlayer pFromName(String name) {
        return this.plugin().getServer().getOfflinePlayer(name);
    }

    @Deprecated
    public int getPlayerInfoInteger(@Nullable String world, String name, String node, int defaultValue) {
        return this.getPlayerInfoInteger(world, this.pFromName(name), node, defaultValue);
    }

    @Deprecated
    public void setPlayerInfoInteger(@Nullable String world, String name, String node, int value) {
        this.setPlayerInfoInteger(world, this.pFromName(name), node, value);
    }

    @Deprecated
    public @Nullable String getPlayerInfoString(@Nullable String world, String name, String node, @Nullable String defaultValue) {
        return this.getPlayerInfoString(world, this.pFromName(name), node, defaultValue);
    }

    @Deprecated
    public void setPlayerInfoString(@Nullable String world, String name, String node, String value) {
        this.setPlayerInfoString(world, this.pFromName(name), node, value);
    }

    @Deprecated
    public boolean getPlayerInfoBoolean(@Nullable String world, String name, String node, boolean defaultValue) {
        return this.getPlayerInfoBoolean(world, this.pFromName(name), node, defaultValue);
    }

    @Deprecated
    public void setPlayerInfoBoolean(@Nullable String world, String name, String node, boolean value) {
        this.setPlayerInfoBoolean(world, this.pFromName(name), node, value);
    }

    @Deprecated
    public double getPlayerInfoDouble(@Nullable String world, String name, String node, double defaultValue) {
        return this.getPlayerInfoDouble(world, this.pFromName(name), node, defaultValue);
    }

    @Deprecated
    public void setPlayerInfoDouble(@Nullable String world, String name, String node, double value) {
        this.setPlayerInfoDouble(world, this.pFromName(name), node, value);
    }

    @Deprecated
    public @Nullable String getPlayerPrefix(@Nullable String world, String name) {
        return this.getPlayerPrefix(world, this.pFromName(name));
    }

    @Deprecated
    public void setPlayerPrefix(@Nullable String world, String name, String prefix) {
        this.setPlayerPrefix(world, this.pFromName(name), prefix);
    }

    @Deprecated
    public @Nullable String getPlayerSuffix(@Nullable String world, String name) {
        return this.getPlayerSuffix(world, this.pFromName(name));
    }

    @Deprecated
    public void setPlayerSuffix(@Nullable String world, String name, String suffix) {
        this.setPlayerSuffix(world, this.pFromName(name), suffix);
    }
}

