/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.CraftBukkitInterface;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class PermissibleInjector {
    static final PermissibleInjector[] INJECTORS = new PermissibleInjector[]{new ClassPresencePermissibleInjector("net.glowstone.entity.GlowHumanEntity", "permissions", true), new ClassPresencePermissibleInjector("org.getspout.server.entity.SpoutHumanEntity", "permissions", true), new ClassNameRegexPermissibleInjector("org.getspout.spout.player.SpoutCraftPlayer", "perm", false, Pattern.compile("org\\.getspout\\.spout\\.player\\.SpoutCraftPlayer")), new ClassPresencePermissibleInjector(CraftBukkitInterface.craftClassName("entity.CraftHumanEntity"), "perm", true)};
    protected final @Nullable String clazzName;
    protected final String fieldName;
    protected final boolean copyValues;

    PermissibleInjector(@Nullable String clazzName, String fieldName, boolean copyValues) {
        this.clazzName = clazzName;
        this.fieldName = fieldName;
        this.copyValues = copyValues;
    }

    public @Nullable Permissible inject(Player player, @Nullable Permissible permissible) throws NoSuchFieldException, IllegalAccessException {
        @Nullable Field permField = this.getPermissibleField(player);
        if (permField == null) {
            return null;
        }
        Permissible oldPerm = (Permissible)permField.get(player);
        if (this.copyValues && permissible instanceof PermissibleBase) {
            PermissibleBase newBase = (PermissibleBase)permissible;
            PermissibleBase oldBase = (PermissibleBase)oldPerm;
            this.copyValues(oldBase, newBase);
        }
        permField.set(player, permissible);
        return oldPerm;
    }

    public Permissible getPermissible(Player player) throws NoSuchFieldException, IllegalAccessException {
        return (Permissible)this.getPermissibleField(player).get(player);
    }

    private @Nullable Field getPermissibleField(Player player) throws NoSuchFieldException {
        Class<?> humanEntity;
        try {
            humanEntity = Class.forName(this.clazzName);
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("PermissionsEx").warning("[PermissionsEx] Unknown server implementation being used!");
            return null;
        }
        if (!humanEntity.isAssignableFrom(player.getClass())) {
            Logger.getLogger("PermissionsEx").warning("[PermissionsEx] Strange error while injecting permissible!");
            return null;
        }
        Field permField = humanEntity.getDeclaredField(this.fieldName);
        permField.setAccessible(true);
        return permField;
    }

    private void copyValues(PermissibleBase old, PermissibleBase newPerm) throws NoSuchFieldException, IllegalAccessException {
        Field attachmentField = PermissibleBase.class.getDeclaredField("attachments");
        attachmentField.setAccessible(true);
        List attachmentPerms = (List)attachmentField.get(newPerm);
        attachmentPerms.clear();
        attachmentPerms.addAll((List)attachmentField.get(old));
        newPerm.recalculatePermissions();
    }

    public abstract boolean isApplicable(Player var1);

    static final class ClassNameRegexPermissibleInjector
    extends PermissibleInjector {
        private final Pattern regex;

        ClassNameRegexPermissibleInjector(String clazz, String field, boolean copyValues, Pattern regex) {
            super(clazz, field, copyValues);
            this.regex = regex;
        }

        @Override
        public boolean isApplicable(Player player) {
            return this.regex.matcher(player.getClass().getName()).matches();
        }
    }

    static final class ClassPresencePermissibleInjector
    extends PermissibleInjector {
        ClassPresencePermissibleInjector(@Nullable String clazzName, String fieldName, boolean copyValues) {
            super(clazzName, fieldName, copyValues);
        }

        @Override
        public boolean isApplicable(Player player) {
            if (this.clazzName == null) {
                return false;
            }
            try {
                return Class.forName(this.clazzName).isInstance(player);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }

    static final class ServerNamePermissibleInjector
    extends PermissibleInjector {
        private final String serverName;

        ServerNamePermissibleInjector(String clazz, String field, boolean copyValues, String serverName) {
            super(clazz, field, copyValues);
            this.serverName = serverName;
        }

        @Override
        public boolean isApplicable(Player player) {
            return player.getServer().getName().equalsIgnoreCase(this.serverName);
        }
    }
}

