/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.bukkit.BukkitCommander;
import ca.stellardrift.permissionsex.bukkit.BukkitConfiguration;
import ca.stellardrift.permissionsex.bukkit.BukkitContexts;
import ca.stellardrift.permissionsex.bukkit.BukkitMessageFormatter;
import ca.stellardrift.permissionsex.bukkit.Messages;
import ca.stellardrift.permissionsex.bukkit.PEXPermissible;
import ca.stellardrift.permissionsex.bukkit.PEXPermissionSubscriptionMap;
import ca.stellardrift.permissionsex.bukkit.PermissibleInjector;
import ca.stellardrift.permissionsex.bukkit.PermissionList;
import ca.stellardrift.permissionsex.bukkit.PluginIntegrations;
import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.impl.logging.WrappingFormattedLogger;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.minecraft.BaseDirectoryScope;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.sql.hikari.Hikari;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.bukkit.CloudBukkitCapabilities;
import cloud.commandframework.bukkit.arguments.selector.SinglePlayerSelector;
import cloud.commandframework.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import cloud.commandframework.paper.PaperCommandManager;
import cloud.commandframework.permission.PredicatePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.impl.JDK14LoggerAdapter;

public final class PermissionsExPlugin
extends JavaPlugin
implements Listener {
    private @MonotonicNonNull FormattedLogger logger;
    private @MonotonicNonNull Path dataPath;
    private @Nullable BukkitAudiences adventure;
    private @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private @Nullable PermissionList permissionList;
    private @Nullable PEXPermissionSubscriptionMap subscriptionHandler;

    public PermissionsEngine engine() {
        return this.manager().engine();
    }

    MinecraftPermissionsEx<BukkitConfiguration> manager() {
        @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager = this.manager;
        if (manager == null) {
            throw new IllegalStateException("PermissionsEx is not currently initialized! Check for an earlier error, or whether permissions may be checked too early.");
        }
        return manager;
    }

    public SubjectTypeCollection<UUID> users() {
        return this.manager().users();
    }

    public SubjectTypeCollection<String> groups() {
        return this.manager().groups();
    }

    private FormattedLogger makeLogger() {
        try {
            Constructor adapter = JDK14LoggerAdapter.class.getDeclaredConstructor(java.util.logging.Logger.class);
            adapter.setAccessible(true);
            return WrappingFormattedLogger.of((Logger)((Logger)adapter.newInstance(this.getLogger())), (boolean)true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private CommandManager<Commander> createCommandManager(Function<CommandTree<Commander>, CommandExecutionCoordinator<Commander>> execCoord) throws RuntimeException {
        PaperCommandManager mgr;
        try {
            mgr = new PaperCommandManager((Plugin)this, execCoord, sender -> new BukkitCommander(this, (CommandSender)sender), commander -> ((BukkitCommander)commander).source());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (mgr.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            mgr.registerBrigadier();
        }
        if (mgr.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            mgr.registerAsynchronousCompletions();
        }
        return mgr;
    }

    private void registerBukkitCommands(CommandRegistrationContext reg) {
        reg.register(builder -> {
            Permission perm = Permission.pex((String)"bukkit.resendtree");
            CommandArgument targetArg = SinglePlayerSelectorArgument.of((String)"target");
            return builder.literal("resendtree", new String[0]).argument(targetArg).permission((PredicatePermission)perm).meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_TREE_DESCRIPTION.tr(new Object[0])).meta(MinecraftExtrasMetaKeys.LONG_DESCRIPTION, (Object)Messages.COMMAND_TREE_LONG_DESCRIPTION.tr(new Object[0])).handler(ctx -> {
                SinglePlayerSelector target = (SinglePlayerSelector)ctx.get(targetArg);
                if (target.getPlayer() == null) {
                    throw new CommandException((Component)Messages.COMMAND_TREE_NO_TARGET.tr(new Object[]{target.getSelector()}));
                }
                try {
                    target.getPlayer().updateCommands();
                    ((Commander)ctx.getSender()).sendMessage((Component)Messages.COMMAND_TREE_REFRESHED.tr(new Object[]{target.getPlayer().getName()}));
                }
                catch (NoSuchMethodError ex) {
                    ((Commander)ctx.getSender()).sendMessage((Component)Messages.COMMAND_TREE_UNSUPPORTED.tr(new Object[]{Bukkit.getVersion()}));
                }
            });
        }, "permissionsex", new String[0]);
    }

    public void onEnable() {
        this.dataPath = this.getDataFolder().toPath();
        this.logger = this.makeLogger();
        this.adventure = BukkitAudiences.create((Plugin)this);
        try {
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
            this.manager = MinecraftPermissionsEx.builder(BukkitConfiguration.class).configuration(this.dataPath.resolve("config.yml")).asyncExecutor((Executor)this.executorService).databaseProvider(url -> Hikari.createDataSource((String)url, (Path)this.dataPath)).logger((Logger)this.logger).baseDirectory(BaseDirectoryScope.JAR, Bukkit.getUpdateFolderFile().toPath()).baseDirectory(BaseDirectoryScope.SERVER, this.dataPath.toAbsolutePath().getParent().getParent()).baseDirectory(BaseDirectoryScope.WORLDS, Bukkit.getWorldContainer().toPath()).opProvider(it -> this.getServer().getOperators().contains(this.getServer().getOfflinePlayer(it))).cachedUuidResolver(it -> this.getServer().getOfflinePlayer(it).getUniqueId()).playerProvider(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).commands(this::createCommandManager).messageFormatter(BukkitMessageFormatter::new).commandContributor(this::registerBukkitCommands).create();
        }
        catch (Exception ex) {
            this.logger.error((Component)Messages.ERROR_ON_ENABLE.tr(new Object[]{this.getDescription().getName()}), (Throwable)ex);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.engine().registerContextDefinitions(new ContextDefinition[]{BukkitContexts.world(), BukkitContexts.dimension(), BukkitContexts.remoteIp(), BukkitContexts.remoteIp(), BukkitContexts.localHost(), BukkitContexts.localPort()});
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.subscriptionHandler = PEXPermissionSubscriptionMap.inject(this, this.getServer().getPluginManager());
        this.permissionList = PermissionList.inject(this);
        this.injectAllPermissibles();
        PluginIntegrations.detectWorldGuard(this);
        PluginIntegrations.detectVault(this);
    }

    public void onDisable() {
        boolean successful;
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
        if (this.subscriptionHandler != null) {
            this.subscriptionHandler.uninject();
            this.subscriptionHandler = null;
        }
        if (this.permissionList != null) {
            this.permissionList.uninject();
            this.permissionList = null;
        }
        this.uninjectAllPermissibles();
        this.executorService.shutdown();
        try {
            successful = this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            successful = false;
        }
        if (!successful) {
            this.logger.error((Component)Messages.ERROR_DISABLE_TASK_TIMEOUT.tr(new Object[0]));
            this.executorService.shutdownNow();
        }
        this.adventure.close();
        this.adventure = null;
    }

    @EventHandler
    void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        this.users().get((Object)event.getUniqueId()).exceptionally(e -> {
            this.logger.warn((Component)Messages.ERROR_LOAD_PRELOGIN.tr(new Object[]{event.getName(), event.getUniqueId().toString(), e.getMessage()}), e);
            return null;
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onPlayerLogin(PlayerLoginEvent event) {
        UUID identifier = event.getPlayer().getUniqueId();
        this.users().transientData().update((Object)identifier, it -> it.withSegment(PermissionsEngine.GLOBAL_CONTEXT, segment -> segment.withOption("hostname", StringUtils.substringBeforeLast((String)event.getHostname(), (String)":"))));
        this.users().isRegistered((Object)identifier).thenAccept(registered -> {
            if (registered.booleanValue()) {
                this.users().persistentData().update((Object)identifier, input -> input.withSegment(PermissionsEngine.GLOBAL_CONTEXT, it -> {
                    if (!event.getPlayer().getName().equals(it.options().get("name"))) {
                        return it.withOption("name", event.getPlayer().getName());
                    }
                    return it;
                }));
            }
        });
        this.injectPermissible(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerLoginDeny(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            this.uninjectPermissible(event.getPlayer());
            this.users().uncache((Object)event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerQuit(PlayerQuitEvent event) {
        this.uninjectPermissible(event.getPlayer());
        @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager = this.manager;
        if (manager != null) {
            manager.callbackController().clearOwnedBy(event.getPlayer().getUniqueId());
            manager.users().uncache((Object)event.getPlayer().getUniqueId());
        }
    }

    private void injectPermissible(Player player) {
        try {
            PEXPermissible permissible = new PEXPermissible(player, this);
            boolean success = false;
            boolean found = false;
            for (PermissibleInjector injector : PermissibleInjector.INJECTORS) {
                if (!injector.isApplicable(player)) continue;
                found = true;
                @Nullable Permissible oldPerm = injector.inject(player, (Permissible)permissible);
                if (oldPerm == null) continue;
                permissible.previousPermissible = oldPerm;
                success = true;
                break;
            }
            if (!found) {
                this.logger.warn((Component)Messages.SUPERPERMS_INJECT_NO_INJECTOR.tr(new Object[0]));
            } else if (!success) {
                this.logger.warn((Component)Messages.SUPERPERMS_INJECT_ERROR_GENERIC.tr(new Object[]{player.getName()}));
            }
            permissible.recalculatePermissions();
            if (success && this.engine().debugMode()) {
                this.logger.info((Component)Messages.SUPERPERMS_INJECT_SUCCESS.tr(new Object[0]));
            }
        }
        catch (Throwable ex) {
            this.logger.error((Component)Messages.SUPERPERMS_INJECT_ERROR_GENERIC.tr(new Object[]{player.getName()}), ex);
        }
    }

    private void injectAllPermissibles() {
        this.getServer().getOnlinePlayers().forEach(this::injectPermissible);
    }

    private void uninjectPermissible(Player player) {
        try {
            boolean success = false;
            for (PermissibleInjector injector : PermissibleInjector.INJECTORS) {
                if (!injector.isApplicable(player)) continue;
                Permissible pexPerm = injector.getPermissible(player);
                if (pexPerm instanceof PEXPermissible) {
                    if (injector.inject(player, ((PEXPermissible)pexPerm).previousPermissible) == null) continue;
                    success = true;
                    break;
                }
                success = true;
                break;
            }
            if (!success) {
                this.logger.warn((Component)Messages.SUPERPERMS_UNINJECT_NO_INJECTOR.tr(new Object[]{player.getName()}));
            } else if (this.manager != null && this.engine().debugMode()) {
                this.logger.info((Component)Messages.SUPERPERMS_UNINJECT_SUCCESS.tr(new Object[]{player.getName()}));
            }
        }
        catch (Throwable ex) {
            this.logger.error((Component)Messages.SUPERPERMS_UNINJECT_ERROR.tr(new Object[]{player.getName()}), ex);
        }
    }

    private void uninjectAllPermissibles() {
        this.getServer().getOnlinePlayers().forEach(this::uninjectPermissible);
    }

    @Nullable PermissionList permissionList() {
        return this.permissionList;
    }

    BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure while the plugin was not enabled");
        }
        return this.adventure;
    }

    FormattedLogger logger() {
        return this.manager().engine().logger();
    }
}

