/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.Messages;
import ca.stellardrift.permissionsex.bukkit.PEXVault;
import ca.stellardrift.permissionsex.bukkit.PEXVaultChat;
import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.SimpleContextDefinition;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PluginIntegrations {
    PluginIntegrations() {
    }

    static void detectWorldGuard(PermissionsExPlugin plugin) {
        @Nullable Plugin wgPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        if (wgPlugin != null) {
            try {
                Class.forName("com.sk89q.worldguard.WorldGuard");
            }
            catch (ClassNotFoundException ex) {
                return;
            }
            plugin.engine().registerContextDefinition((ContextDefinition)new WorldGuardRegionContext((WorldGuardPlugin)wgPlugin));
            plugin.logger().info((Component)Messages.INTEGRATIONS_WORLDGUARD_SUCCESS.tr(new Object[0]));
        }
    }

    static void detectVault(PermissionsExPlugin plugin) {
        if (plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            PEXVault vault = new PEXVault(plugin);
            ServicesManager services = plugin.getServer().getServicesManager();
            services.register(Permission.class, (Object)vault, (Plugin)plugin, ServicePriority.High);
            services.register(Chat.class, (Object)new PEXVaultChat(vault), (Plugin)plugin, ServicePriority.High);
            plugin.logger().info((Component)Messages.INTEGRATIONS_VAULT_SUCCESS.tr(new Object[0]));
        }
    }

    static final class WorldGuardRegionContext
    extends SimpleContextDefinition {
        private final WorldGuardPlugin plugin;

        WorldGuardRegionContext(WorldGuardPlugin plugin) {
            super("region");
            this.plugin = plugin;
        }

        public void accumulateCurrentValues(CalculatedSubject subject, Consumer<String> consumer) {
            @Nullable Object associated = subject.associatedObject();
            if (associated instanceof Player) {
                LocalPlayer wgPlayer = this.plugin.wrapPlayer((Player)associated);
                @Nullable RegionManager regionProvider = WorldGuard.getInstance().getPlatform().getRegionContainer().get(wgPlayer.getWorld());
                if (regionProvider != null) {
                    ApplicableRegionSet regions = regionProvider.getApplicableRegions(wgPlayer.getLocation().toVector().toBlockPoint());
                    HashSet<ProtectedRegion> seen = new HashSet<ProtectedRegion>();
                    Iterator iterator = regions.iterator();
                    while (iterator.hasNext()) {
                        ProtectedRegion region;
                        for (ProtectedRegion current = region = (ProtectedRegion)iterator.next(); current != null && !seen.contains(current); current = current.getParent()) {
                            seen.add(current);
                            consumer.accept(region.getId());
                        }
                    }
                }
            }
        }

        public Set<String> suggestValues(CalculatedSubject subject) {
            @Nullable Object associated = subject.associatedObject();
            if (associated instanceof Player) {
                LocalPlayer wgPlayer = this.plugin.wrapPlayer((Player)associated);
                @Nullable RegionManager container = WorldGuard.getInstance().getPlatform().getRegionContainer().get(wgPlayer.getWorld());
                if (container != null) {
                    return container.getRegions().keySet();
                }
            }
            return PCollections.set();
        }
    }
}

