/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.SimpleContextDefinition;
import ca.stellardrift.permissionsex.datastore.ConversionResult;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.exception.PEBKACException;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.BaseDirectoryScope;
import ca.stellardrift.permissionsex.impl.ImplementationInterface;
import ca.stellardrift.permissionsex.impl.Messages;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryDataStore;
import ca.stellardrift.permissionsex.impl.commands.CallbackController;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandSpec;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.context.PEXContextDefinition;
import ca.stellardrift.permissionsex.impl.context.ServerTagContextDefinition;
import ca.stellardrift.permissionsex.impl.context.TimeContextDefinition;
import ca.stellardrift.permissionsex.impl.data.CacheListenerHolder;
import ca.stellardrift.permissionsex.impl.data.RankLadderCache;
import ca.stellardrift.permissionsex.impl.data.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.logging.DebugPermissionCheckNotifier;
import ca.stellardrift.permissionsex.impl.logging.RecordingPermissionCheckNotifier;
import ca.stellardrift.permissionsex.impl.logging.WrappingFormattedLogger;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public class PermissionsEx<P>
implements ImplementationInterface,
Consumer<ContextInheritance>,
ContextDefinitionProvider,
PermissionsEngine {
    private final FormattedLogger logger;
    private final ImplementationInterface impl;
    private final MemoryDataStore transientData;
    private final RecordingPermissionCheckNotifier baseNotifier = new RecordingPermissionCheckNotifier();
    private volatile PermissionCheckNotifier notifier = this.baseNotifier;
    private final ConcurrentMap<String, ContextDefinition<?>> contextTypes = new ConcurrentHashMap();
    private final AtomicReference<@Nullable State<P>> state = new AtomicReference();
    private final ConcurrentMap<String, SubjectTypeCollectionImpl<?>> subjectTypeCache = new ConcurrentHashMap();
    private @MonotonicNonNull RankLadderCache rankLadderCache;
    private volatile @Nullable CompletableFuture<ContextInheritance> cachedInheritance;
    private final CacheListenerHolder<Boolean, ContextInheritance> cachedInheritanceListeners = new CacheListenerHolder();
    private final CallbackController callbackController;

    public SubjectRef<?> deserializeSubjectRef(Map.Entry<String, String> serialized) {
        @Nullable SubjectTypeCollectionImpl existingCollection = (SubjectTypeCollectionImpl)this.subjectTypeCache.get(serialized.getKey());
        if (existingCollection == null) {
            throw new IllegalArgumentException("Unknown subject type " + serialized.getKey());
        }
        return this.deserialize(existingCollection.type(), serialized.getValue());
    }

    private <I> SubjectRef<I> deserialize(SubjectType<I> type, String serializedIdent) {
        return SubjectRef.subject(type, (Object)type.parseIdentifier(serializedIdent));
    }

    public PermissionsEx(PermissionsExConfiguration<P> config, ImplementationInterface impl) throws PermissionsLoadingException {
        this.impl = impl;
        this.logger = WrappingFormattedLogger.of(impl.logger(), false);
        this.transientData = MemoryDataStore.create("transient");
        this.transientData.initialize(this);
        this.callbackController = new CallbackController();
        this.debugMode(config.isDebugEnabled());
        this.registerContextDefinitions(ServerTagContextDefinition.INSTANCE, TimeContextDefinition.BEFORE_TIME, TimeContextDefinition.AFTER_TIME);
        this.initialize(config);
        this.subjects(SUBJECTS_DEFAULTS);
        this.subjects(SUBJECTS_FALLBACK);
    }

    public void registerCommandsTo(Consumer<CommandSpec> consumer) {
    }

    private State<P> getState() throws IllegalStateException {
        @Nullable State<P> ret = this.state.get();
        if (ret == null) {
            throw new IllegalStateException("Manager has already been closed!");
        }
        return ret;
    }

    public <I> SubjectTypeCollectionImpl<I> subjects(SubjectType<I> type) {
        SubjectTypeCollectionImpl collection = this.subjectTypeCache.computeIfAbsent(type.name(), key -> new SubjectTypeCollectionImpl(this, type, new SubjectDataCacheImpl(type, ((State)this.getState()).activeDataStore), new SubjectDataCacheImpl(type, this.transientData)));
        if (!type.equals(collection.type())) {
            throw new IllegalArgumentException("Provided subject type " + type + " is different from registered type " + collection.type());
        }
        return collection;
    }

    public Collection<SubjectTypeCollectionImpl<?>> loadedSubjectTypes() {
        return Collections.unmodifiableCollection(this.subjectTypeCache.values());
    }

    public Set<SubjectType<?>> knownSubjectTypes() {
        return this.subjectTypeCache.values().stream().map(SubjectTypeCollectionImpl::type).collect(Collectors.toSet());
    }

    public <V> CompletableFuture<V> doBulkOperation(Function<DataStore, CompletableFuture<V>> actor) {
        return ((State)this.getState()).activeDataStore.performBulkOperation(actor).thenCompose(it -> it);
    }

    public <T> CompletableFuture<T> performBulkOperation(Supplier<CompletableFuture<T>> func) {
        return ((State)this.getState()).activeDataStore.performBulkOperation(store -> ((CompletableFuture)func.get()).join());
    }

    public RankLadderCache getLadders() {
        return this.rankLadderCache;
    }

    public CompletableFuture<Void> importDataFrom(String dataStoreIdentifier) {
        State<P> state = this.getState();
        @Nullable DataStore expected = ((State)state).config.getDataStore(dataStoreIdentifier);
        if (expected == null) {
            return Util.failedFuture(new IllegalArgumentException("Data store " + dataStoreIdentifier + " is not present"));
        }
        return this.importDataFrom(expected);
    }

    public CompletableFuture<Void> importDataFrom(ConversionResult conversion) {
        return this.importDataFrom(conversion.store());
    }

    private CompletableFuture<Void> importDataFrom(DataStore expected) {
        State<P> state = this.getState();
        try {
            expected.initialize((PermissionsEngine)this);
        }
        catch (PermissionsLoadingException e) {
            return Util.failedFuture(e);
        }
        return ((State)state).activeDataStore.performBulkOperation(store -> {
            CompletionStage ret = CompletableFuture.allOf((CompletableFuture[])Iterables.toArray((Iterable)Iterables.transform((Iterable)expected.getAll(), input -> store.setData((String)((Map.Entry)input.getKey()).getKey(), (String)((Map.Entry)input.getKey()).getValue(), (ImmutableSubjectData)input.getValue())), CompletableFuture.class)).thenCombine(expected.getContextInheritance(null).thenCompose(arg_0 -> ((DataStore)store).setContextInheritance(arg_0)), (v, a) -> null);
            for (String ladder : expected.getAllRankLadders()) {
                ret = ((CompletableFuture)ret).thenCombine(expected.getRankLadder(ladder, null).thenCompose(ladderObj -> store.setRankLadder(ladder, ladderObj)), (v, a) -> null);
            }
            return ret;
        }).thenCompose(val -> Util.failableFuture(val::get));
    }

    public PermissionCheckNotifier getNotifier() {
        return this.notifier;
    }

    public RecordingPermissionCheckNotifier getRecordingNotifier() {
        return this.baseNotifier;
    }

    public boolean debugMode() {
        return this.getNotifier() instanceof DebugPermissionCheckNotifier;
    }

    public synchronized void debugMode(boolean debug2, @Nullable Pattern filterPattern) {
        if (debug2) {
            this.notifier = this.notifier instanceof DebugPermissionCheckNotifier ? new DebugPermissionCheckNotifier(this.logger(), ((DebugPermissionCheckNotifier)this.notifier).getDelegate(), filterPattern == null ? null : perm -> filterPattern.matcher((CharSequence)perm).find()) : new DebugPermissionCheckNotifier(this.logger(), this.notifier, filterPattern == null ? null : perm -> filterPattern.matcher((CharSequence)perm).find());
        } else if (this.notifier instanceof DebugPermissionCheckNotifier) {
            this.notifier = ((DebugPermissionCheckNotifier)this.notifier).getDelegate();
        }
    }

    private void reloadSync() throws PEBKACException, PermissionsLoadingException {
        try {
            PermissionsExConfiguration config = ((State)this.getState()).config.reload();
            config.validate();
            this.initialize(config);
        }
        catch (IOException e) {
            throw new PEBKACException((Component)Messages.CONFIG_ERROR_LOAD.tr(new Object[]{e.getLocalizedMessage()}));
        }
    }

    private void initialize(PermissionsExConfiguration<P> config) throws PermissionsLoadingException {
        State newState = new State(config, config.getDefaultDataStore());
        boolean shouldAnnounceImports = !newState.activeDataStore.initialize((PermissionsEngine)this);
        try {
            newState.config.save();
        }
        catch (IOException e) {
            throw new PermissionsLoadingException((Component)Messages.CONFIG_ERROR_SAVE.tr(new Object[0]), (Throwable)e);
        }
        if (shouldAnnounceImports) {
            this.logger().warn((Component)Messages.CONVERSION_BANNER.tr(new Object[0]));
        }
        TreePVector allResults = TreePVector.empty();
        for (DataStoreFactory convertable : DataStoreFactory.all().values()) {
            DataStoreFactory.Convertable prov;
            PVector res;
            if (!(convertable instanceof DataStoreFactory.Convertable) || (res = (prov = (DataStoreFactory.Convertable)convertable).listConversionOptions((PermissionsEngine)this)).isEmpty()) continue;
            if (shouldAnnounceImports) {
                this.logger().info((Component)Messages.CONVERSION_PLUGINHEADER.tr(new Object[]{prov.friendlyName()}));
                for (ConversionResult result : res) {
                    this.logger().info((Component)Messages.CONVERSION_INSTANCE.tr(new Object[]{result.description(), result.store().getName()}));
                }
            }
            allResults = allResults.plusAll((Collection)res);
        }
        newState.availableConversions = (PVector)allResults;
        State oldState = this.state.getAndSet(newState);
        if (oldState != null) {
            try {
                oldState.activeDataStore.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rankLadderCache = new RankLadderCache(this.rankLadderCache, newState.activeDataStore);
        this.subjectTypeCache.forEach((key, val) -> val.update(newState.activeDataStore));
        this.contextTypes.values().forEach(ctxDef -> {
            if (ctxDef instanceof PEXContextDefinition) {
                ((PEXContextDefinition)((Object)ctxDef)).update(newState.config);
            }
        });
        if (this.cachedInheritance != null) {
            this.cachedInheritance = null;
            this.getContextInheritance(null).thenAccept(inheritance -> this.cachedInheritanceListeners.call(true, (ContextInheritance)inheritance));
        }
        newState.activeDataStore.moveData("system", SUBJECTS_DEFAULTS.name(), SUBJECTS_DEFAULTS.name(), SUBJECTS_DEFAULTS.name()).thenRun(() -> this.logger().info((Component)Messages.CONVERSION_RESULT_SUCCESS.tr(new Object[0])));
    }

    public CompletableFuture<Void> reload() {
        return Util.asyncFailableFuture(() -> {
            this.reloadSync();
            return null;
        }, this.asyncExecutor());
    }

    public void close() {
        State state = this.state.getAndSet(null);
        state.activeDataStore.close();
    }

    public List<ConversionResult> getAvailableConversions() {
        return ((State)this.getState()).availableConversions;
    }

    public CallbackController getCallbackController() {
        return this.callbackController;
    }

    public FormattedLogger logger() {
        return this.logger;
    }

    @Override
    public Path baseDirectory() {
        return this.impl.baseDirectory();
    }

    @Override
    public Path baseDirectory(BaseDirectoryScope scope) {
        return this.impl.baseDirectory(scope);
    }

    @Override
    @Deprecated
    public DataSource dataSourceForUrl(String url) throws SQLException {
        return this.impl.dataSourceForUrl(url);
    }

    @Override
    public Executor asyncExecutor() {
        return this.impl.asyncExecutor();
    }

    @Override
    public Set<CommandSpec> getImplementationSubcommands() {
        return this.impl.getImplementationSubcommands();
    }

    @Override
    public String getVersion() {
        return this.impl.getVersion();
    }

    @Override
    public Map.Entry<String, String> createSubjectIdentifier(String collection, String ident) {
        return this.impl.createSubjectIdentifier(collection, ident);
    }

    public PermissionsExConfiguration<P> getConfig() {
        return ((State)this.getState()).config;
    }

    public CompletableFuture<ContextInheritance> getContextInheritance(@Nullable Consumer<ContextInheritance> listener) {
        if (this.cachedInheritance == null) {
            this.cachedInheritance = ((State)this.getState()).activeDataStore.getContextInheritance((Consumer)this);
        }
        if (listener != null) {
            this.cachedInheritanceListeners.addListener(true, listener);
        }
        return this.cachedInheritance;
    }

    public CompletableFuture<ContextInheritance> setContextInheritance(ContextInheritance newInheritance) {
        return ((State)this.getState()).activeDataStore.setContextInheritance(newInheritance);
    }

    @Override
    public void accept(ContextInheritance newData) {
        this.cachedInheritance = CompletableFuture.completedFuture(newData);
        this.cachedInheritanceListeners.call(true, newData);
    }

    public CompletableFuture<Set<ContextDefinition<?>>> usedContextTypes() {
        return ((State)this.getState()).activeDataStore.getDefinedContextKeys().thenCombine(this.transientData.getDefinedContextKeys(), (persist, trans) -> {
            ImmutableSet.Builder build = ImmutableSet.builder();
            for (ContextDefinition def : this.contextTypes.values()) {
                if (!persist.contains(def.name()) && !trans.contains(def.name())) continue;
                build.add((Object)def);
            }
            return build.build();
        });
    }

    public <T> boolean registerContextDefinition(ContextDefinition<T> contextDefinition) {
        ContextDefinition<T> possibleOut;
        if (contextDefinition instanceof PEXContextDefinition && this.state.get() != null) {
            ((PEXContextDefinition)contextDefinition).update(this.getConfig());
        }
        if ((possibleOut = this.contextTypes.putIfAbsent(contextDefinition.name(), contextDefinition)) instanceof SimpleContextDefinition.Fallback) {
            return this.contextTypes.replace(contextDefinition.name(), possibleOut, contextDefinition);
        }
        return possibleOut == null;
    }

    public int registerContextDefinitions(ContextDefinition<?> ... definitions) {
        int numRegistered = 0;
        for (ContextDefinition<?> def : definitions) {
            if (!this.registerContextDefinition(def)) continue;
            ++numRegistered;
        }
        return numRegistered;
    }

    public List<ContextDefinition<?>> registeredContextTypes() {
        return ImmutableList.copyOf(this.contextTypes.values());
    }

    public @Nullable ContextDefinition<?> contextDefinition(String definitionKey, boolean allowFallbacks) {
        SimpleContextDefinition.Fallback fallback;
        @Nullable ContextDefinition ret = (ContextDefinition)this.contextTypes.get(definitionKey);
        if (ret == null && allowFallbacks && (ret = (ContextDefinition)this.contextTypes.putIfAbsent(definitionKey, (ContextDefinition<?>)(fallback = new SimpleContextDefinition.Fallback(definitionKey)))) == null) {
            ret = fallback;
        }
        return ret;
    }

    private static class State<P> {
        private final PermissionsExConfiguration<P> config;
        private final DataStore activeDataStore;
        private PVector<ConversionResult> availableConversions = TreePVector.empty();

        private State(PermissionsExConfiguration<P> config, DataStore activeDataStore) {
            this.config = config;
            this.activeDataStore = activeDataStore;
        }
    }
}

