/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.impl.backend.memory.MemorySubjectData;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public final class FileSubjectData
extends MemorySubjectData {
    static final String KEY_CONTEXTS = "contexts";

    static FileSubjectData fromNode(ConfigurationNode node) throws SerializationException, PermissionsLoadingException {
        HashMap map = new HashMap();
        if (node.isList()) {
            for (ConfigurationNode child : node.childrenList()) {
                if (!child.isMap()) {
                    throw new PermissionsLoadingException((Component)Messages.FILE_LOAD_CONTEXT.tr(new Object[0]));
                }
                Set<ContextValue<?>> contexts = FileSubjectData.contextsFrom(child);
                MemorySubjectData.DataEntry value = (MemorySubjectData.DataEntry)MAPPER.load(child);
                map.put(contexts, value);
            }
        }
        return new FileSubjectData(Collections.unmodifiableMap(map));
    }

    FileSubjectData() {
    }

    FileSubjectData(Map<Set<ContextValue<?>>, MemorySubjectData.DataEntry> contexts) {
        super(contexts);
    }

    @Override
    protected MemorySubjectData newData(Map<Set<ContextValue<?>>, MemorySubjectData.DataEntry> contexts) {
        return new FileSubjectData(contexts);
    }

    private static Set<ContextValue<?>> contextsFrom(ConfigurationNode node) {
        ImmutableSet contexts = Collections.emptySet();
        ConfigurationNode contextsNode = node.node(new Object[]{KEY_CONTEXTS});
        if (contextsNode.isMap()) {
            contexts = ImmutableSet.copyOf((Collection)Collections2.transform(contextsNode.childrenMap().entrySet(), ent -> new ContextValue(ent.getKey().toString(), ((ConfigurationNode)ent.getValue()).getString())));
        }
        return contexts;
    }

    void serialize(ConfigurationNode node) throws SerializationException {
        if (!node.isList()) {
            node.raw(null);
        }
        HashMap existingSections = new HashMap();
        for (ConfigurationNode configurationNode : node.childrenList()) {
            existingSections.put(FileSubjectData.contextsFrom(configurationNode), configurationNode);
        }
        for (Map.Entry entry : this.contexts.entrySet()) {
            ConfigurationNode contextSection = (ConfigurationNode)existingSections.remove(entry.getKey());
            if (contextSection == null) {
                contextSection = node.appendListNode();
                ConfigurationNode contextsNode = contextSection.node(new Object[]{KEY_CONTEXTS});
                for (ContextValue context : (Set)entry.getKey()) {
                    contextsNode.node(new Object[]{context.key()}).set((Object)context.rawValue());
                }
            }
            MAPPER.save((Object)((MemorySubjectData.DataEntry)entry.getValue()), contextSection);
        }
        for (ConfigurationNode configurationNode : existingSections.values()) {
            configurationNode.raw(null);
        }
    }

    @Override
    public String toString() {
        return "FileOptionSubjectData{contexts=" + this.contexts + '}';
    }
}

