/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.impl.backend.ConversionUtils;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public class SchemaMigrations {
    public static final int LATEST_VERSION = 4;
    private static final TransformAction MOVE_PREFIX_SUFFIX_ACTION = (nodePath, configurationNode) -> {
        ConfigurationNode defaultNode;
        ConfigurationNode suffixNode;
        ConfigurationNode prefixNode = configurationNode.node(new Object[]{"prefix"});
        if (!prefixNode.virtual()) {
            configurationNode.node(new Object[]{"options", "prefix"}).from(prefixNode);
            prefixNode.set(null);
        }
        if (!(suffixNode = configurationNode.node(new Object[]{"suffix"})).virtual()) {
            configurationNode.node(new Object[]{"options", "suffix"}).from(suffixNode);
            suffixNode.raw(null);
        }
        if (!(defaultNode = configurationNode.node(new Object[]{"default"})).virtual()) {
            configurationNode.node(new Object[]{"options", "default"}).from(defaultNode);
            defaultNode.raw(null);
        }
        return null;
    };

    private SchemaMigrations() {
    }

    private static ConfigurationTransformation.Builder tBuilder() {
        return ConfigurationTransformation.builder();
    }

    static <N extends ScopedConfigurationNode<N>> ConfigurationTransformation versionedMigration(FormattedLogger logger) {
        return ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"schema-version"}).addVersion(4, SchemaMigrations.threeToFour()).addVersion(3, SchemaMigrations.twoTo3()).addVersion(2, SchemaMigrations.oneTo2(logger)).addVersion(1, SchemaMigrations.initialTo1()).build();
    }

    static ConfigurationTransformation threeToFour() {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{"worlds", ConfigurationTransformation.WILDCARD_OBJECT, "inheritance"}), (inputPath, valueAtPath) -> {
            List items = valueAtPath.getList(String.class);
            valueAtPath.raw(null);
            items.stream().map(input -> "world:" + input).forEach(longer -> valueAtPath.appendListNode().raw(longer));
            return new Object[]{"context-inheritance", "world:" + inputPath.get(1)};
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{"worlds"}), (inputPath, valueAtPath) -> {
            valueAtPath.raw(null);
            return null;
        }).build()});
    }

    static ConfigurationTransformation twoTo3() {
        HashMap convertedRanks = new HashMap();
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT}), (nodePath, configurationNode) -> {
            if (configurationNode.isMap()) {
                String lastPath = nodePath.get(0).toString();
                if (lastPath.endsWith("s")) {
                    lastPath = lastPath.substring(0, lastPath.length() - 1);
                }
                return new Object[]{"subjects", lastPath};
            }
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{"subjects", "group", ConfigurationTransformation.WILDCARD_OBJECT}), (nodePath, configurationNode) -> {
            for (ConfigurationNode child : configurationNode.childrenList()) {
                if (!child.node(new Object[]{"contexts"}).virtual() && !child.node(new Object[]{"contexts"}).childrenMap().isEmpty()) continue;
                ConfigurationNode optionsNode = child.node(new Object[]{"options"});
                if (optionsNode.virtual()) {
                    return null;
                }
                ConfigurationNode rank = optionsNode.node(new Object[]{"rank"});
                if (rank.virtual()) continue;
                String rankLadder = optionsNode.node(new Object[]{"rank-ladder"}).getString("default");
                List tempVals = convertedRanks.computeIfAbsent(rankLadder.toLowerCase(), k -> new ArrayList());
                tempVals.add(UnmodifiableCollections.immutableMapEntry((Object)configurationNode.key().toString(), (Object)rank.getInt()));
                rank.raw(null);
                optionsNode.node(new Object[]{"rank-ladder"}).raw(null);
                if (!optionsNode.childrenMap().isEmpty()) continue;
                optionsNode.raw(null);
            }
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path(), (nodePath, configurationNode) -> {
            for (Map.Entry ent : convertedRanks.entrySet()) {
                ((List)ent.getValue()).sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
                ConfigurationNode ladderNode = configurationNode.node(new Object[]{"rank-ladders", ent.getKey()});
                for (Map.Entry grp : (List)ent.getValue()) {
                    ladderNode.appendListNode().set((Object)("group:" + (String)grp.getKey()));
                }
            }
            return null;
        }).build()});
    }

    static ConfigurationTransformation oneTo2(FormattedLogger logger) {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT}), (nodePath, configurationNode) -> {
            ConfigurationNode src = configurationNode.copy();
            configurationNode.appendListNode().from(src);
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, 0, "worlds"}), (nodePath, configurationNode) -> {
            ConfigurationNode entityNode = configurationNode.parent().parent();
            for (Map.Entry ent : configurationNode.childrenMap().entrySet()) {
                entityNode.appendListNode().from((ConfigurationNode)ent.getValue()).node(new Object[]{"contexts", "world"}).set(ent.getKey());
            }
            configurationNode.raw(null);
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "permissions"}), (nodePath, configurationNode) -> {
            List existing = configurationNode.getList(String.class, Collections.emptyList());
            if (!existing.isEmpty()) {
                configurationNode.raw(Collections.emptyMap());
            }
            for (String permission2 : existing) {
                int value;
                int n = value = permission2.startsWith("-") ? -1 : 1;
                if (value < 0) {
                    permission2 = permission2.substring(1);
                }
                if (permission2.equals("*")) {
                    configurationNode.parent().node(new Object[]{"permissions-default"}).set((Object)value);
                    continue;
                }
                if ((permission2 = ConversionUtils.convertLegacyPermission(permission2)).contains("*")) {
                    logger.warn((Component)Messages.FILE_CONVERSION_ILLEGAL_CHAR.tr(new Object[]{configurationNode.path()}));
                }
                configurationNode.node(new Object[]{permission2}).raw((Object)value);
            }
            if (configurationNode.empty()) {
                configurationNode.raw(null);
            }
            return null;
        }).addAction(NodePath.path((Object[])new Object[]{"users", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "group"}), (nodePath, configurationNode) -> {
            Object[] retPath = nodePath.array();
            retPath[retPath.length - 1] = "parents";
            for (ConfigurationNode child : configurationNode.childrenList()) {
                child.set((Object)("group:" + child.getString()));
            }
            return retPath;
        }).addAction(NodePath.path((Object[])new Object[]{"groups", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "inheritance"}), (nodePath, configurationNode) -> {
            Object[] retPath = nodePath.array();
            retPath[retPath.length - 1] = "parents";
            for (ConfigurationNode child : configurationNode.childrenList()) {
                child.set((Object)("group:" + child.getString()));
            }
            return retPath;
        }).addAction(NodePath.path((Object[])new Object[]{"groups", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT}), (inputPath, valueAtPath) -> {
            ConfigurationNode defaultNode = valueAtPath.node(new Object[]{"options", "default"});
            if (!defaultNode.virtual()) {
                if (defaultNode.getBoolean()) {
                    ConfigurationNode addToNode = null;
                    ConfigurationNode defaultsParent = valueAtPath.parent().parent().parent().node(new Object[]{"fallbacks", "user"});
                    Object contexts = valueAtPath.node(new Object[]{"contexts"}).raw();
                    for (ConfigurationNode node : defaultsParent.childrenList()) {
                        if (!Objects.equals(node.node(new Object[]{"contexts"}).raw(), contexts)) continue;
                        addToNode = node;
                        break;
                    }
                    if (addToNode == null) {
                        addToNode = defaultsParent.appendListNode();
                        addToNode.node(new Object[]{"contexts"}).set((Object)valueAtPath.node(new Object[]{"contexts"}));
                    }
                    addToNode.node(new Object[]{"parents"}).appendListNode().set((Object)("group:" + valueAtPath.parent().key()));
                }
                defaultNode.raw(null);
                ConfigurationNode optionsNode = valueAtPath.node(new Object[]{"options"});
                if (optionsNode.childrenMap().isEmpty()) {
                    optionsNode.raw(null);
                }
            }
            return null;
        }).build()});
    }

    static ConfigurationTransformation initialTo1() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT}), MOVE_PREFIX_SUFFIX_ACTION).addAction(NodePath.path((Object[])new Object[]{ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "worlds", ConfigurationTransformation.WILDCARD_OBJECT}), MOVE_PREFIX_SUFFIX_ACTION).build();
    }
}

