/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.impl.commands.commander.Commander;
import ca.stellardrift.permissionsex.impl.commands.commander.Permission;
import ca.stellardrift.permissionsex.impl.commands.parse.ArgumentParseException;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandContext;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandElement;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandException;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.QuotedStringParser;
import ca.stellardrift.permissionsex.util.TextExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B]\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005j\u0004\u0018\u0001`\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0006J\t\u0010\u001d\u001a\u00020\u0003H\u00c2\u0003J#\u0010\u001e\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005j\u0004\u0018\u0001`\tH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000eH\u00c2\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003Jk\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\"\b\u0002\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005j\u0004\u0018\u0001`\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0006J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0016\u0010-\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007J\u000e\u0010-\u001a\u00020\u00072\u0006\u00100\u001a\u00020\fJ\u0016\u00101\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u00102\u001a\u00020\fJ$\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010(\u001a\u00020\u00062\u0006\u00100\u001a\u00020\fJ\t\u00104\u001a\u00020\fH\u00d6\u0001J\u001e\u00105\u001a\n 6*\u0004\u0018\u00010.0.*\u00020\f2\b\b\u0002\u00107\u001a\u00020%H\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R+\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005j\u0004\u0018\u0001`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00068"}, d2={"Lca/stellardrift/permissionsex/impl/commands/parse/CommandSpec;", "", "args", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandElement;", "executor", "Lkotlin/Function2;", "Lca/stellardrift/permissionsex/impl/commands/commander/Commander;", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandContext;", "", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandAction;", "aliases", "", "", "description", "Lnet/kyori/adventure/text/Component;", "extendedDescription", "permission", "Lca/stellardrift/permissionsex/impl/commands/commander/Permission;", "(Lca/stellardrift/permissionsex/impl/commands/parse/CommandElement;Lkotlin/jvm/functions/Function2;Ljava/util/List;Lnet/kyori/adventure/text/Component;Lnet/kyori/adventure/text/Component;Lca/stellardrift/permissionsex/impl/commands/commander/Permission;)V", "getAliases", "()Ljava/util/List;", "getDescription", "()Lnet/kyori/adventure/text/Component;", "getExecutor", "()Lkotlin/jvm/functions/Function2;", "getPermission", "()Lca/stellardrift/permissionsex/impl/commands/commander/Permission;", "checkPermission", "commander", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "getExtendedDescription", "src", "getUsage", "hasPermission", "hashCode", "", "parse", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandArgs;", "context", "commandLine", "process", "arguments", "tabComplete", "toString", "parseToCommand", "kotlin.jvm.PlatformType", "lenient", "core"})
public final class CommandSpec {
    private final CommandElement args;
    @Nullable
    private final Function2<Commander, CommandContext, Unit> executor;
    @NotNull
    private final List<String> aliases;
    @Nullable
    private final Component description;
    private final Component extendedDescription;
    @Nullable
    private final Permission permission;

    public final void process(@NotNull Commander commander, @NotNull String arguments) {
        Intrinsics.checkNotNullParameter((Object)commander, (String)"commander");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Function2<Commander, CommandContext, Unit> function2 = this.executor;
        if (function2 == null) {
            return;
        }
        Function2<Commander, CommandContext, Unit> executor2 = function2;
        try {
            this.checkPermission(commander);
            CommandContext args = this.parse(arguments);
            executor2.invoke((Object)commander, (Object)args);
        }
        catch (CommandException ex) {
            Component component = ex.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"ex.component");
            commander.error(component, null);
            TranslatableComponent translatableComponent = Messages.USAGE.tr(new Object[]{this.getUsage(commander)});
            Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"Messages.USAGE.tr(getUsage(commander))");
            commander.error((Component)translatableComponent, null);
        }
        catch (Throwable t) {
            Object[] objectArray = new Object[1];
            String string = t.getMessage();
            Intrinsics.checkNotNull((Object)string);
            objectArray[0] = string;
            TranslatableComponent translatableComponent = Messages.ERROR_GENERAL.tr(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"Messages.ERROR_GENERAL.tr(t.message!!)");
            commander.error((Component)translatableComponent, t);
            t.printStackTrace();
        }
    }

    public final void checkPermission(@NotNull Commander commander) throws CommandException {
        Intrinsics.checkNotNullParameter((Object)commander, (String)"commander");
        if (!this.hasPermission(commander)) {
            TranslatableComponent translatableComponent = Messages.ERROR_PERMISSION.tr(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"Messages.ERROR_PERMISSION.tr()");
            throw (Throwable)((Object)new CommandException((Component)translatableComponent));
        }
    }

    public final boolean hasPermission(@NotNull Commander src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.permission == null || src.hasPermission(this.permission);
    }

    @NotNull
    public final CommandContext parse(@NotNull String commandLine) throws ArgumentParseException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        CommandArgs args = CommandSpec.parseToCommand$default(this, commandLine, false, 1, null);
        CommandContext context = new CommandContext(this, commandLine);
        CommandArgs commandArgs = args;
        Intrinsics.checkNotNullExpressionValue((Object)commandArgs, (String)"args");
        this.parse(commandArgs, context);
        return context;
    }

    public final void parse(@NotNull CommandArgs args, @NotNull CommandContext context) throws ArgumentParseException {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.args.parse(args, context);
        if (args.hasNext()) {
            args.next();
            TranslatableComponent translatableComponent = Messages.ERROR_ARGUMENTS_TOOMANY.tr(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"Messages.ERROR_ARGUMENTS_TOOMANY.tr()");
            throw (Throwable)((Object)args.createError((Component)translatableComponent));
        }
    }

    @NotNull
    public final List<String> tabComplete(@NotNull Commander src, @NotNull String commandLine) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        try {
            this.checkPermission(src);
        }
        catch (CommandException ex) {
            return CollectionsKt.emptyList();
        }
        try {
            CommandArgs args = this.parseToCommand(commandLine, true);
            CommandContext context = new CommandContext(this, commandLine);
            CommandArgs commandArgs = args;
            Intrinsics.checkNotNullExpressionValue((Object)commandArgs, (String)"args");
            list = this.tabComplete(src, commandArgs, context);
        }
        catch (ArgumentParseException e) {
            Component component = e.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"e.component");
            src.debug(component);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<String> tabComplete(@NotNull Commander src, @NotNull CommandArgs args, @NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.args.tabComplete(src, args, context);
    }

    private final CommandArgs parseToCommand(String $this$parseToCommand, boolean lenient) throws ArgumentParseException {
        return QuotedStringParser.parseFrom($this$parseToCommand, lenient);
    }

    static /* synthetic */ CommandArgs parseToCommand$default(CommandSpec commandSpec, String string, boolean bl, int n, Object object) throws ArgumentParseException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return commandSpec.parseToCommand(string, bl);
    }

    @NotNull
    public final Component getUsage(@NotNull Commander commander) {
        Intrinsics.checkNotNullParameter((Object)commander, (String)"commander");
        BuildableComponent buildableComponent = ((TextComponent.Builder)TextExtensionsKt.unaryMinus('/' + this.aliases.get(0) + ' ').append(this.args.getUsage(commander))).build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"(-\"/${aliases[0]} \").app\u2026Usage(commander)).build()");
        return (Component)buildableComponent;
    }

    @NotNull
    public final Component getExtendedDescription(@NotNull Commander src) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (this.description == null) {
            if (this.extendedDescription == null) {
                component = this.getUsage(src);
            } else {
                TextComponent textComponent = Component.join((ComponentLike)((ComponentLike)Component.newline()), (ComponentLike[])new ComponentLike[]{(ComponentLike)this.getUsage(src), (ComponentLike)this.extendedDescription});
                Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"Component.join(\n        \u2026ription\n                )");
                component = (Component)textComponent;
            }
        } else {
            TextComponent textComponent = this.extendedDescription == null ? Component.join((ComponentLike)((ComponentLike)Component.newline()), (ComponentLike[])new ComponentLike[]{(ComponentLike)this.description, (ComponentLike)this.getUsage(src)}) : Component.join((ComponentLike)((ComponentLike)Component.newline()), (ComponentLike[])new ComponentLike[]{(ComponentLike)this.description, (ComponentLike)this.getUsage(src), (ComponentLike)this.extendedDescription});
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"if (extendedDescription \u2026n\n            )\n        }");
            component = (Component)textComponent;
        }
        return component;
    }

    @Nullable
    public final Function2<Commander, CommandContext, Unit> getExecutor() {
        return this.executor;
    }

    @NotNull
    public final List<String> getAliases() {
        return this.aliases;
    }

    @Nullable
    public final Component getDescription() {
        return this.description;
    }

    @Nullable
    public final Permission getPermission() {
        return this.permission;
    }

    public CommandSpec(@NotNull CommandElement args, @Nullable Function2<? super Commander, ? super CommandContext, Unit> executor2, @NotNull List<String> aliases, @Nullable Component description, @Nullable Component extendedDescription, @Nullable Permission permission2) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        this.args = args;
        this.executor = executor2;
        this.aliases = aliases;
        this.description = description;
        this.extendedDescription = extendedDescription;
        this.permission = permission2;
    }

    private final CommandElement component1() {
        return this.args;
    }

    @Nullable
    public final Function2<Commander, CommandContext, Unit> component2() {
        return this.executor;
    }

    @NotNull
    public final List<String> component3() {
        return this.aliases;
    }

    @Nullable
    public final Component component4() {
        return this.description;
    }

    private final Component component5() {
        return this.extendedDescription;
    }

    @Nullable
    public final Permission component6() {
        return this.permission;
    }

    @NotNull
    public final CommandSpec copy(@NotNull CommandElement args, @Nullable Function2<? super Commander, ? super CommandContext, Unit> executor2, @NotNull List<String> aliases, @Nullable Component description, @Nullable Component extendedDescription, @Nullable Permission permission2) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        return new CommandSpec(args, executor2, aliases, description, extendedDescription, permission2);
    }

    public static /* synthetic */ CommandSpec copy$default(CommandSpec commandSpec, CommandElement commandElement, Function2 function2, List list, Component component, Component component2, Permission permission2, int n, Object object) {
        if ((n & 1) != 0) {
            commandElement = commandSpec.args;
        }
        if ((n & 2) != 0) {
            function2 = commandSpec.executor;
        }
        if ((n & 4) != 0) {
            list = commandSpec.aliases;
        }
        if ((n & 8) != 0) {
            component = commandSpec.description;
        }
        if ((n & 0x10) != 0) {
            component2 = commandSpec.extendedDescription;
        }
        if ((n & 0x20) != 0) {
            permission2 = commandSpec.permission;
        }
        return commandSpec.copy(commandElement, function2, list, component, component2, permission2);
    }

    @NotNull
    public String toString() {
        return "CommandSpec(args=" + this.args + ", executor=" + this.executor + ", aliases=" + this.aliases + ", description=" + this.description + ", extendedDescription=" + this.extendedDescription + ", permission=" + this.permission + ")";
    }

    public int hashCode() {
        CommandElement commandElement = this.args;
        Function2<Commander, CommandContext, Unit> function2 = this.executor;
        List<String> list = this.aliases;
        Component component = this.description;
        Component component2 = this.extendedDescription;
        Permission permission2 = this.permission;
        return (((((commandElement != null ? commandElement.hashCode() : 0) * 31 + (function2 != null ? function2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (component != null ? component.hashCode() : 0)) * 31 + (component2 != null ? component2.hashCode() : 0)) * 31 + (permission2 != null ? ((Object)permission2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CommandSpec)) break block3;
                CommandSpec commandSpec = (CommandSpec)object;
                if (!Intrinsics.areEqual((Object)this.args, (Object)commandSpec.args) || !Intrinsics.areEqual(this.executor, commandSpec.executor) || !Intrinsics.areEqual(this.aliases, commandSpec.aliases) || !Intrinsics.areEqual((Object)this.description, (Object)commandSpec.description) || !Intrinsics.areEqual((Object)this.extendedDescription, (Object)commandSpec.extendedDescription) || !Intrinsics.areEqual((Object)this.permission, (Object)commandSpec.permission)) break block3;
            }
            return true;
        }
        return false;
    }
}

