/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.impl.commands.commander.Commander;
import ca.stellardrift.permissionsex.impl.commands.parse.ArgumentParseException;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandContext;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandElement;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.Value;
import ca.stellardrift.permissionsex.impl.commands.parse.ValueElement;
import ca.stellardrift.permissionsex.impl.util.GuavaStartsWithPredicate;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

public class StructuralArguments {
    private static CommandElement markTrue(String flag) {
        return new MarkTrueCommandElement().key(flag);
    }

    public static FlagCommandElementBuilder flags() {
        return new FlagCommandElementBuilder();
    }

    public static CommandElement seq(CommandElement ... elements) {
        return new SequenceCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement firstParsing(CommandElement ... elements) {
        return new FirstParsingCommandElement((List)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement optional(CommandElement element) {
        return new OptionalCommandElement(element, null, false);
    }

    public static CommandElement optionalWeak(CommandElement element) {
        return new OptionalCommandElement(element, null, true);
    }

    public static CommandElement optional(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, false);
    }

    public static CommandElement optionalWeak(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, true);
    }

    public static CommandElement repeated(CommandElement element, int times) {
        return new RepeatedCommandElement(element, times);
    }

    public static CommandElement allOf(CommandElement element) {
        return new AllOfCommandElement(element);
    }

    private static class AllOfCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected AllOfCommandElement(CommandElement element) {
            this.element = element;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            while (args.hasNext()) {
                this.element.parse(args, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            while (args.hasNext()) {
                int startPos = args.getPosition();
                try {
                    this.element.parse(args, context);
                }
                catch (ArgumentParseException e) {
                    args.setPosition(startPos);
                    return this.element.tabComplete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander context) {
            return this.element.getUsage(context).append((Component)Component.text((String)"+"));
        }
    }

    private static class RepeatedCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final int times;

        protected RepeatedCommandElement(CommandElement element, int times) {
            this.element = element;
            this.times = times;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (int i = 0; i < this.times; ++i) {
                this.element.parse(args, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            for (int i = 0; i < this.times; ++i) {
                int startPos = args.getPosition();
                try {
                    this.element.parse(args, context);
                    continue;
                }
                catch (ArgumentParseException e) {
                    args.setPosition(startPos);
                    return this.element.tabComplete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander src) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(this.times)).append((Component)Component.text((String)"*"))).append(this.element.getUsage(src))).build();
        }
    }

    private static class OptionalCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final Object value;
        private final boolean considerInvalidFormatEmpty;

        private OptionalCommandElement(CommandElement element, Object value, boolean considerInvalidFormatEmpty) {
            this.element = element;
            this.value = value;
            this.considerInvalidFormatEmpty = considerInvalidFormatEmpty;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            if (!args.hasNext()) {
                return;
            }
            int startPos = args.getPosition();
            try {
                this.element.parse(args, context);
            }
            catch (ArgumentParseException ex) {
                if (this.considerInvalidFormatEmpty || args.hasNext()) {
                    args.setPosition(startPos);
                }
                throw ex;
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            return this.element.tabComplete(src, args, context);
        }

        @Override
        public Component getUsage(Commander src) {
            return Component.text(builder -> {
                builder.append((Component)Component.text((String)"["));
                builder.append(this.element.getUsage(src));
                builder.append((Component)Component.text((String)"]"));
            });
        }
    }

    private static class FirstParsingCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        private FirstParsingCommandElement(List<CommandElement> elements) {
            this.elements = elements;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            ArgumentParseException firstException = null;
            for (CommandElement element : this.elements) {
                int startIndex = args.getPosition();
                try {
                    element.parse(args, context);
                    return;
                }
                catch (ArgumentParseException ex) {
                    if (firstException == null) {
                        firstException = ex;
                    }
                    args.setPosition(startIndex);
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.elements, input -> {
                int startIndex = args.getPosition();
                List<String> ret = input.tabComplete(src, args, context);
                args.setPosition(startIndex);
                return ret;
            })));
        }

        @Override
        public Component getUsage(Commander commander) {
            return Component.text(builder -> {
                Iterator<CommandElement> it = this.elements.iterator();
                while (it.hasNext()) {
                    builder.append(it.next().getUsage(commander));
                    if (!it.hasNext()) continue;
                    builder.append((Component)Component.text((String)"|"));
                }
            });
        }
    }

    static class SequenceCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        SequenceCommandElement(List<CommandElement> elements) {
            this.elements = elements;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (CommandElement element : this.elements) {
                element.parse(args, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                CommandElement element = it.next();
                int startPos = args.getPosition();
                try {
                    element.parse(args, context);
                    int endPos = args.getPosition();
                    if (!args.hasNext()) {
                        args.setPosition(startPos);
                        List<String> inputs = element.tabComplete(src, args, context);
                        args.setPosition(args.getPosition() - 1);
                        if (!inputs.contains(args.next())) {
                            return inputs;
                        }
                        args.setPosition(endPos);
                    }
                }
                catch (ArgumentParseException e) {
                    args.setPosition(startPos);
                    return element.tabComplete(src, args, context);
                }
                if (it.hasNext()) continue;
                args.setPosition(startPos);
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander commander) {
            return Component.text(builder -> {
                Iterator<CommandElement> it = this.elements.iterator();
                while (it.hasNext()) {
                    builder.append(it.next().getUsage(commander));
                    if (!it.hasNext()) continue;
                    builder.append((Component)Component.space());
                }
            });
        }
    }

    private static class FlagCommandElement
    extends CommandElement {
        private final CommandElement childElement;
        private final Map<List<String>, CommandElement> usageFlags;
        private final Map<String, CommandElement> shortFlags;
        private final Map<String, CommandElement> longFlags;
        private final UnknownFlagBehavior unknownShortFlagBehavior;
        private final UnknownFlagBehavior unknownLongFlagBehavior;
        private final boolean anchorFlags;

        protected FlagCommandElement(CommandElement childElement, Map<List<String>, CommandElement> usageFlags, Map<String, CommandElement> shortFlags, Map<String, CommandElement> longFlags, UnknownFlagBehavior unknownShortFlagBehavior, UnknownFlagBehavior unknownLongFlagBehavior, boolean anchorFlags) {
            this.childElement = childElement;
            this.usageFlags = usageFlags;
            this.shortFlags = shortFlags;
            this.longFlags = longFlags;
            this.unknownShortFlagBehavior = unknownShortFlagBehavior;
            this.unknownLongFlagBehavior = unknownLongFlagBehavior;
            this.anchorFlags = anchorFlags;
        }

        @Override
        public void parse(CommandArgs args, CommandContext context) throws ArgumentParseException {
            int startIdx = args.getPosition();
            while (args.hasNext()) {
                String arg = args.next();
                if (arg.startsWith("-")) {
                    boolean ignored;
                    int flagStartIdx = args.getPosition();
                    if (arg.startsWith("--")) {
                        String longFlag = arg.substring(2);
                        ignored = !this.parseLongFlag(longFlag, args, context);
                    } else {
                        boolean bl = ignored = !this.parseShortFlags(arg = arg.substring(1), args, context);
                    }
                    if (ignored) continue;
                    args.removeArgs(flagStartIdx, args.getPosition());
                    continue;
                }
                if (!this.anchorFlags) continue;
            }
            args.setPosition(startIdx);
            if (this.childElement != null) {
                this.childElement.parse(args, context);
            }
        }

        private boolean parseLongFlag(String longFlag, CommandArgs args, CommandContext context) throws ArgumentParseException {
            if (longFlag.isEmpty()) {
                return false;
            }
            if (longFlag.contains("=")) {
                String[] flagSplit = longFlag.split("=", 2);
                longFlag = flagSplit[0];
                String value = flagSplit[1];
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    switch (this.unknownLongFlagBehavior) {
                        case ERROR: {
                            throw args.createError((Component)Messages.FLAG_ERROR_UNKNOWNLONG.tr(new Object[]{longFlag}));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(longFlag, (Object)value);
                            break;
                        }
                        case IGNORE: {
                            return false;
                        }
                    }
                } else {
                    args.insertArg(value);
                    element.parse(args, context);
                }
            } else {
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    switch (this.unknownLongFlagBehavior) {
                        case ERROR: {
                            throw args.createError((Component)Messages.FLAG_ERROR_UNKNOWNLONG.tr(new Object[]{longFlag}));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(longFlag, (Object)true);
                            break;
                        }
                        case IGNORE: {
                            return false;
                        }
                    }
                    context.putArg(longFlag, (Object)true);
                } else {
                    element.parse(args, context);
                }
            }
            return true;
        }

        private boolean parseShortFlags(String shortFlags, CommandArgs args, CommandContext context) throws ArgumentParseException {
            if (shortFlags.isEmpty()) {
                return false;
            }
            for (int i = 0; i < shortFlags.length(); ++i) {
                String flagChar = shortFlags.substring(i, i + 1);
                CommandElement element = this.shortFlags.get(flagChar);
                if (element == null) {
                    switch (this.unknownShortFlagBehavior) {
                        case IGNORE: {
                            if (i == 0) {
                                return false;
                            }
                        }
                        case ERROR: {
                            throw args.createError((Component)Messages.FLAG_ERROR_UNKNOWNSHORT.tr(new Object[]{flagChar}));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(flagChar, (Object)true);
                        }
                    }
                    continue;
                }
                element.parse(args, context);
            }
            return true;
        }

        @Override
        public Component getUsage(Commander src) {
            return Component.text(builder -> {
                for (Map.Entry<List<String>, CommandElement> arg : this.usageFlags.entrySet()) {
                    builder.append((Component)Component.text((String)"["));
                    Iterator<String> it = arg.getKey().iterator();
                    while (it.hasNext()) {
                        builder.append((Component)Component.text((String)"-"));
                        builder.append((Component)Component.text((String)it.next()));
                        if (!it.hasNext()) continue;
                        builder.append((Component)Component.text((String)"|"));
                    }
                    if (!(arg.getValue() instanceof ValueElement) || !(((ValueElement)arg.getValue()).getValue() instanceof MarkTrueCommandElement)) {
                        builder.append((Component)Component.text((String)" "));
                        builder.append(arg.getValue().getUsage(src));
                    }
                    builder.append((Component)Component.text((String)"]"));
                    builder.append((Component)Component.text((String)" "));
                }
                if (this.childElement != null) {
                    builder.append(this.childElement.getUsage(src));
                }
            });
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args, CommandContext context) {
            int startIdx = args.getPosition();
            while (args.hasNext()) {
                String arg = args.nextIfPresent();
                if (arg.startsWith("-")) {
                    String argStr;
                    String longFlag;
                    List<String> ret;
                    int flagStartIdx = args.getPosition();
                    if (arg.startsWith("--") ? (ret = this.tabCompleteLongFlag(longFlag = arg.substring(2), src, args, context)) != null : (ret = this.tabCompleteShortFlags(argStr = arg.substring(1), src, args, context)) != null) {
                        return ret;
                    }
                    args.removeArgs(flagStartIdx, args.getPosition());
                    continue;
                }
                if (!this.anchorFlags) continue;
            }
            args.setPosition(startIdx);
            if (this.childElement != null) {
                return this.childElement.tabComplete(src, args, context);
            }
            return Collections.emptyList();
        }

        private List<String> tabCompleteLongFlag(String longFlag, Commander src, CommandArgs args, CommandContext context) {
            if (longFlag.isEmpty()) {
                return null;
            }
            if (longFlag.contains("=")) {
                String[] flagSplit = longFlag.split("=", 2);
                longFlag = flagSplit[0];
                String value = flagSplit[1];
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    if (this.unknownLongFlagBehavior != UnknownFlagBehavior.IGNORE) {
                        context.putArg(longFlag, (Object)value);
                    }
                } else {
                    args.insertArg(value);
                    String finalLongFlag = longFlag;
                    int position = args.getPosition();
                    try {
                        element.parse(args, context);
                    }
                    catch (ArgumentParseException ex) {
                        args.setPosition(position);
                        return ImmutableList.copyOf((Iterable)Iterables.transform(element.tabComplete(src, args, context), input -> "--" + finalLongFlag + "=" + input));
                    }
                }
            } else {
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.longFlags.keySet(), (Predicate)new GuavaStartsWithPredicate(longFlag.toLowerCase())), input -> "--" + input));
                }
                boolean complete = false;
                int position = args.getPosition();
                try {
                    element.parse(args, context);
                }
                catch (ArgumentParseException ex) {
                    complete = true;
                }
                if (!args.hasNext()) {
                    complete = true;
                }
                if (complete) {
                    args.setPosition(position);
                    return element.tabComplete(src, args, context);
                }
            }
            return null;
        }

        private List<String> tabCompleteShortFlags(String shortFlags, Commander src, CommandArgs args, CommandContext context) {
            if (shortFlags.isEmpty()) {
                return null;
            }
            for (int i = 0; i < shortFlags.length(); ++i) {
                String flagChar = shortFlags.substring(i, i + 1);
                CommandElement element = this.shortFlags.get(flagChar);
                if (element == null) continue;
                int start = args.getPosition();
                try {
                    element.parse(args, context);
                    continue;
                }
                catch (ArgumentParseException ex) {
                    args.setPosition(start);
                    return element.tabComplete(src, args, context);
                }
            }
            return null;
        }
    }

    public static class FlagCommandElementBuilder {
        private final Map<List<String>, CommandElement> usageFlags = new HashMap<List<String>, CommandElement>();
        private final Map<String, CommandElement> shortFlags = new HashMap<String, CommandElement>();
        private final Map<String, CommandElement> longFlags = new HashMap<String, CommandElement>();
        private UnknownFlagBehavior unknownLongFlagBehavior = UnknownFlagBehavior.ERROR;
        private UnknownFlagBehavior unknownShortFlagBehavior = UnknownFlagBehavior.ERROR;
        private boolean anchorFlags = false;

        public FlagCommandElementBuilder flag(String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            CommandElement el = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    String flagKey = spec.substring(1);
                    if (el == null) {
                        el = StructuralArguments.markTrue(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.longFlags.put(flagKey.toLowerCase(), el);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (el == null) {
                        el = StructuralArguments.markTrue(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, el);
                }
            }
            this.usageFlags.put(availableFlags, el);
            return this;
        }

        public FlagCommandElementBuilder valueFlag(CommandElement value, String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            String valueStore = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    availableFlags.add(spec);
                    String flagKey = spec.substring(1);
                    if (valueStore == null) {
                        valueStore = flagKey;
                    }
                    this.longFlags.put(flagKey.toLowerCase(), value);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (valueStore == null) {
                        valueStore = flagKey;
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, value);
                }
            }
            this.usageFlags.put(availableFlags, StructuralArguments.markTrue(valueStore));
            return this;
        }

        public FlagCommandElementBuilder setUnknownLongFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownLongFlagBehavior = behavior;
            return this;
        }

        public FlagCommandElementBuilder setUnknownShortFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownShortFlagBehavior = behavior;
            return this;
        }

        public FlagCommandElementBuilder setAnchorFlags(boolean anchorFlags) {
            this.anchorFlags = anchorFlags;
            return this;
        }

        public CommandElement buildWith(CommandElement wrapped) {
            return new FlagCommandElement(wrapped, this.usageFlags, this.shortFlags, this.longFlags, this.unknownShortFlagBehavior, this.unknownLongFlagBehavior, this.anchorFlags);
        }
    }

    private static class MarkTrueCommandElement
    extends Value<Boolean> {
        static final MarkTrueCommandElement INSTANCE = new MarkTrueCommandElement();

        private MarkTrueCommandElement() {
            super((Component)Component.text((String)"true"));
        }

        @Override
        public Boolean parse(@NotNull CommandArgs args) throws ArgumentParseException {
            return true;
        }

        public ValueElement<Boolean> key(String key) {
            return this.key((Component)Component.text((String)key));
        }
    }

    public static enum UnknownFlagBehavior {
        ERROR,
        ACCEPT_NONVALUE,
        ACCEPT_VALUE,
        IGNORE;

    }
}

