/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.Value;
import ca.stellardrift.permissionsex.util.TextExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lca/stellardrift/permissionsex/impl/commands/parse/Uuid;", "Lca/stellardrift/permissionsex/impl/commands/parse/Value;", "Ljava/util/UUID;", "()V", "parse", "args", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandArgs;", "core"})
final class Uuid
extends Value<UUID> {
    @NotNull
    public static final Uuid INSTANCE;

    @Override
    @NotNull
    public UUID parse(@NotNull CommandArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String input = args.next();
        try {
            UUID uUID = UUID.fromString(input);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.fromString(input)");
            return uUID;
        }
        catch (IllegalArgumentException ex) {
            TranslatableComponent translatableComponent = Messages.UUID_ERROR_FORMAT.tr(new Object[]{input});
            Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"Messages.UUID_ERROR_FORMAT.tr(input)");
            throw (Throwable)((Object)args.createError((Component)translatableComponent));
        }
    }

    private Uuid() {
        super((Component)TextExtensionsKt.unaryPlus("a UUID in RFC format"));
    }

    static {
        Uuid uuid;
        INSTANCE = uuid = new Uuid();
    }
}

