/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class DataStoreSerializer
implements TypeSerializer<DataStore> {
    public DataStore deserialize(Type type, ConfigurationNode value) throws SerializationException {
        String dataStoreType = value.node(new Object[]{"type"}).getString(value.key().toString());
        @Nullable DataStoreFactory factory = DataStoreFactory.forType((String)dataStoreType);
        if (factory == null) {
            throw new SerializationException("Unknown DataStore type " + dataStoreType);
        }
        try {
            return factory.create(value.key().toString(), value);
        }
        catch (PermissionsLoadingException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void serialize(Type type, DataStore store, ConfigurationNode value) throws SerializationException {
        try {
            value.node(new Object[]{"type"}).set((Object)store.serialize(value));
        }
        catch (PermissionsLoadingException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

