/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.data;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.impl.data.CacheListenerHolder;
import ca.stellardrift.permissionsex.rank.RankLadder;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class RankLadderCache {
    private final DataStore dataStore;
    private final AsyncLoadingCache<String, RankLadder> cache;
    private final Map<String, Consumer<RankLadder>> cacheHolders = new ConcurrentHashMap<String, Consumer<RankLadder>>();
    private final CacheListenerHolder<String, RankLadder> listeners;

    public RankLadderCache(DataStore dataStore) {
        this(null, dataStore);
    }

    public RankLadderCache(RankLadderCache existing, DataStore dataStore) {
        this.dataStore = dataStore;
        this.cache = Caffeine.newBuilder().maximumSize(256L).buildAsync((key, executor2) -> dataStore.getRankLadder(key, this.clearListener((String)key)));
        if (existing != null) {
            this.listeners = existing.listeners;
            existing.cache.synchronous().asMap().forEach((key, rankLadder) -> this.get((String)key, null).thenAccept(data -> this.listeners.call((String)key, (RankLadder)data)));
        } else {
            this.listeners = new CacheListenerHolder();
        }
    }

    public CompletableFuture<RankLadder> get(String identifier, Consumer<RankLadder> listener) {
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture ret = this.cache.get((Object)identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(identifier, listener);
            }
        });
        return ret;
    }

    public CompletableFuture<RankLadder> update(String identifier, UnaryOperator<RankLadder> updateFunc) {
        return this.cache.get((Object)identifier).thenCompose(oldLadder -> {
            RankLadder newLadder = (RankLadder)updateFunc.apply((RankLadder)oldLadder);
            if (oldLadder == newLadder) {
                return CompletableFuture.completedFuture(newLadder);
            }
            return this.set(identifier, newLadder);
        });
    }

    public void load(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.synchronous().refresh((Object)identifier);
    }

    public void invalidate(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.synchronous().invalidate((Object)identifier);
        this.cacheHolders.remove(identifier);
        this.listeners.removeAll(identifier);
    }

    public CompletableFuture<Boolean> has(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        if (this.cache.synchronous().getIfPresent((Object)identifier) != null) {
            return CompletableFuture.completedFuture(true);
        }
        return this.dataStore.hasRankLadder(identifier);
    }

    public CompletableFuture<RankLadder> set(String identifier, RankLadder newData) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.setRankLadder(identifier, newData);
    }

    private Consumer<RankLadder> clearListener(String name) {
        Consumer<RankLadder> ret = newData -> {
            this.cache.synchronous().put((Object)name, newData);
            this.listeners.call(name, (RankLadder)newData);
        };
        this.cacheHolders.put(name, ret);
        return ret;
    }

    public void addListener(String identifier, Consumer<RankLadder> listener) {
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(listener, "listener");
        this.listeners.addListener(identifier, listener);
    }

    public Iterable<String> getAll() {
        return this.dataStore.getAllRankLadders();
    }
}

