/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.logging.Messages;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class DebugPermissionCheckNotifier
implements PermissionCheckNotifier {
    private final FormattedLogger logger;
    private final PermissionCheckNotifier delegate;
    private final Predicate<String> filterPredicate;

    public DebugPermissionCheckNotifier(FormattedLogger logger, PermissionCheckNotifier delegate, @Nullable Predicate<String> filterPredicate) {
        this.logger = logger;
        this.delegate = delegate;
        this.filterPredicate = filterPredicate == null ? x -> true : filterPredicate;
    }

    private <I> String stringIdentifier(SubjectRef<I> identifier) {
        return identifier.type().name() + " " + identifier.type().serializeIdentifier(identifier.identifier());
    }

    public PermissionCheckNotifier getDelegate() {
        return this.delegate;
    }

    public void onPermissionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String permission2, int value) {
        if (this.filterPredicate.test(permission2)) {
            this.logger.info((Component)Messages.CHECK_PERMISSION.tr(new Object[]{permission2, contexts, this.stringIdentifier(subject2), value}));
        }
        this.delegate.onPermissionCheck(subject2, contexts, permission2, value);
    }

    public void onOptionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String option2, String value) {
        if (this.filterPredicate.test(option2)) {
            this.logger.info((Component)Messages.CHECK_OPTION.tr(new Object[]{option2, contexts, this.stringIdentifier(subject2), value}));
        }
        this.delegate.onOptionCheck(subject2, contexts, option2, value);
    }

    public void onParentCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, List<Map.Entry<String, String>> parents) {
        this.logger.info((Component)Messages.CHECK_PARENT.tr(new Object[]{contexts, this.stringIdentifier(subject2), parents}));
        this.delegate.onParentCheck(subject2, contexts, parents);
    }
}

