/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecordingPermissionCheckNotifier
implements PermissionCheckNotifier {
    private static final int MAX_SIZE = 500;
    private final Set<String> knownPermissions = RecordingPermissionCheckNotifier.sizeLimitedSet(500);
    private final Set<String> knownOptions = RecordingPermissionCheckNotifier.sizeLimitedSet(500);

    private static <T> Set<T> sizeLimitedSet(final int maxSize) {
        return Collections.newSetFromMap(new LinkedHashMap<T, Boolean>(){
            private static final long serialVersionUID = 9025221898274056636L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, Boolean> eldest) {
                return this.size() > maxSize;
            }
        });
    }

    public void onPermissionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String permission2, int value) {
        this.knownPermissions.add(permission2);
    }

    public void onOptionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String option2, String value) {
        this.knownOptions.add(option2);
    }

    public void onParentCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, List<Map.Entry<String, String>> parents) {
    }

    public Set<String> getKnownPermissions() {
        return Collections.unmodifiableSet(this.knownPermissions);
    }

    public Set<String> getKnownOptions() {
        return Collections.unmodifiableSet(this.knownOptions);
    }
}

