/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.rank;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.rank.Messages;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;

public abstract class AbstractRankLadder
implements RankLadder {
    private final String name;

    protected AbstractRankLadder(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public final ImmutableSubjectData promote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        ArrayList parents = input.getParents(contexts);
        if (parents.isEmpty()) {
            return input.addParent(contexts, this.ranks().get(0).getKey(), this.ranks().get(0).getValue());
        }
        parents = new ArrayList(parents);
        boolean found = false;
        ListIterator<Map.Entry<String, String>> it = parents.listIterator();
        while (it.hasNext()) {
            Map.Entry parent = (Map.Entry)it.next();
            int index = this.ranks().indexOf(parent);
            if (index <= -1) continue;
            if (index == this.ranks().size() - 1) {
                return input;
            }
            it.set(this.ranks().get(index + 1));
            found = true;
        }
        if (found) {
            return input.setParents(contexts, parents);
        }
        return input.addParent(contexts, this.ranks().get(0).getKey(), this.ranks().get(0).getValue());
    }

    public final ImmutableSubjectData demote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        ArrayList parents = input.getParents(contexts);
        if (parents.isEmpty()) {
            return input;
        }
        parents = new ArrayList(parents);
        boolean found = false;
        ListIterator<Map.Entry<String, String>> it = parents.listIterator();
        while (it.hasNext()) {
            Map.Entry parent = (Map.Entry)it.next();
            int index = this.ranks().indexOf(parent);
            if (index <= -1) continue;
            if (index == 0) {
                it.remove();
            } else {
                it.set(this.ranks().get(index - 1));
            }
            found = true;
        }
        if (found) {
            return input.setParents(contexts, parents);
        }
        return input;
    }

    public final boolean isOnLadder(Set<ContextValue<?>> contexts, ImmutableSubjectData subject2) {
        if (this.ranks().isEmpty()) {
            return false;
        }
        for (Map.Entry par : subject2.getParents(contexts)) {
            if (this.ranks().indexOf(par) == -1) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(Map.Entry<String, String> subject2) {
        return this.ranks().indexOf(subject2);
    }

    public final RankLadder with(Map.Entry<String, String> subject2) {
        int indexOf = this.ranks().indexOf(subject2);
        if (indexOf != -1) {
            ArrayList<Map.Entry<String, String>> ents = new ArrayList<Map.Entry<String, String>>(this.ranks());
            ents.remove(indexOf);
            ents.add(subject2);
            return this.newWithRanks(ents);
        }
        return this.newWithRanks((List<Map.Entry<String, String>>)ImmutableList.builder().addAll(this.ranks()).add(subject2).build());
    }

    public final RankLadder with(Map.Entry<String, String> subject2, int index) {
        if (index > this.ranks().size() || index < 0) {
            return this;
        }
        int indexOf = this.ranks().indexOf(subject2);
        ArrayList<Map.Entry<String, String>> newEnts = new ArrayList<Map.Entry<String, String>>(this.ranks());
        newEnts.add(index, subject2);
        if (indexOf != -1) {
            if (indexOf >= index) {
                ++indexOf;
            }
            newEnts.remove(indexOf);
        }
        return this.newWithRanks(newEnts);
    }

    public final RankLadder without(Map.Entry<String, String> subject2) {
        int indexOf = this.ranks().indexOf(subject2);
        if (indexOf == -1) {
            return this;
        }
        ArrayList<Map.Entry<String, String>> newRanks = new ArrayList<Map.Entry<String, String>>(this.ranks());
        newRanks.remove(indexOf);
        return this.newWithRanks(newRanks);
    }

    public abstract List<? extends Map.Entry<String, String>> ranks();

    protected abstract RankLadder newWithRanks(List<Map.Entry<String, String>> var1);

    public final Component asComponent() {
        return Component.text(build -> ((TextComponent.Builder)((TextComponent.Builder)build.content(this.name()).decoration(TextDecoration.BOLD, true)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Messages.FORMATTER_BUTTON_INFO_PROMPT.tr(new Object[0])))).clickEvent(ClickEvent.runCommand((String)("/pex rank " + this.name()))));
    }
}

