/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.data.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.subject.CalculatedSubjectImpl;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataBaker;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class SubjectTypeCollectionImpl<I>
implements SubjectTypeCollection<I> {
    private final PermissionsEx<?> pex;
    private final SubjectType<I> type;
    private final SubjectDataCacheImpl<I> persistentData;
    private final SubjectDataCacheImpl<I> transientData;
    private final AsyncLoadingCache<I, CalculatedSubject> cache;

    public SubjectTypeCollectionImpl(PermissionsEx<?> pex, SubjectType<I> type, SubjectDataCacheImpl<I> persistentData, SubjectDataCacheImpl<I> transientData) {
        this.pex = pex;
        this.type = type;
        this.persistentData = persistentData;
        this.transientData = transientData;
        this.cache = Caffeine.newBuilder().executor(pex.asyncExecutor()).buildAsync((key, executor2) -> {
            CalculatedSubjectImpl subj = new CalculatedSubjectImpl(SubjectDataBaker.inheritance(), SubjectRef.subject(this.type, (Object)key), this);
            return persistentData.referenceTo(key, false).thenCombine(transientData.referenceTo(key, false), (persistentRef, transientRef) -> {
                subj.initialize(persistentRef, transientRef);
                return subj;
            });
        });
    }

    public SubjectType<I> type() {
        return this.type;
    }

    public void cacheAll() {
        this.persistentData.cacheAll();
        this.transientData.cacheAll();
    }

    public Collection<CalculatedSubject> activeSubjects() {
        return Collections.unmodifiableCollection(this.cache.synchronous().asMap().values());
    }

    public void uncache(I identifier) {
        this.persistentData.invalidate(identifier);
        this.transientData.invalidate(identifier);
        this.cache.synchronous().invalidate(identifier);
    }

    public CompletableFuture<CalculatedSubject> get(I identifier) {
        return this.cache.get(identifier);
    }

    public SubjectDataCacheImpl<I> transientData() {
        return this.transientData;
    }

    public SubjectDataCacheImpl<I> persistentData() {
        return this.persistentData;
    }

    PermissionsEx<?> getManager() {
        return this.pex;
    }

    public void update(DataStore newDataStore) {
        this.persistentData.update(newDataStore);
    }

    public void load(I identifier) {
        this.persistentData.load(identifier);
        this.transientData.load(identifier);
    }

    public CompletableFuture<Boolean> isRegistered(I identifier) {
        return this.persistentData.isRegistered(identifier).thenCombine(this.transientData.isRegistered(identifier), Boolean::logicalAnd);
    }

    public Stream<I> allIdentifiers() {
        return Stream.concat(this.persistentData.getAllIdentifiers(), this.transientData.getAllIdentifiers()).distinct();
    }
}

