/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.test;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.exception.PEBKACException;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.config.EmptyPlatformConfiguration;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;
import org.mariadb.jdbc.MariaDbDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PermissionsExTest {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TestImpl");
    public static final SubjectType<String> SUBJECTS_GROUP = SubjectType.stringIdentBuilder((String)"group").build();
    public static final SubjectType<UUID> SUBJECTS_USER = SubjectType.builder((String)"user", UUID.class).serializedBy(UUID::toString).deserializedBy(UUID::fromString).build();
    public Path tempFolder;
    private PermissionsEx<?> manager;

    @BeforeEach
    public void setUp(TestInfo info, @TempDir Path tempFolder) throws PermissionsLoadingException, IOException, PEBKACException {
        this.tempFolder = tempFolder;
        PermissionsExConfiguration<EmptyPlatformConfiguration> config = this.populate();
        config.validate();
        PermissionsEx manager = new PermissionsEx(LOGGER, tempFolder.resolve(info.getDisplayName()), Runnable::run, url -> {
            if (url.startsWith("jdbc:h2")) {
                JdbcDataSource ds = new JdbcDataSource();
                ds.setURL(url);
                return ds;
            }
            if (url.startsWith("jdbc:mysql")) {
                return new MariaDbDataSource(url);
            }
            if (url.startsWith("jdbc:postgresql")) {
                PGSimpleDataSource ds = new PGSimpleDataSource();
                ds.setUrl(url);
                return ds;
            }
            throw new IllegalArgumentException("Unsupported database implementation!");
        });
        manager.initialize(config);
        this.manager = manager;
        this.manager.subjects(SUBJECTS_GROUP);
        this.manager.subjects(SUBJECTS_USER);
    }

    @AfterEach
    public void tearDown() {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    protected DataStore dataStore() {
        return this.manager.activeDataStore();
    }

    protected PermissionsEx<?> manager() {
        return this.manager;
    }

    protected abstract PermissionsExConfiguration<EmptyPlatformConfiguration> populate();
}

