/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.SimpleContextDefinition;
import ca.stellardrift.permissionsex.datastore.ConversionResult;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PEBKACException;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.Messages;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryDataStore;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.context.PEXContextDefinition;
import ca.stellardrift.permissionsex.impl.context.ServerTagContextDefinition;
import ca.stellardrift.permissionsex.impl.context.TimeContextDefinition;
import ca.stellardrift.permissionsex.impl.logging.DebugPermissionCheckNotifier;
import ca.stellardrift.permissionsex.impl.logging.RecordingPermissionCheckNotifier;
import ca.stellardrift.permissionsex.impl.logging.WrappingFormattedLogger;
import ca.stellardrift.permissionsex.impl.rank.RankLadderCache;
import ca.stellardrift.permissionsex.impl.subject.LazySubjectRef;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.util.CacheListenerHolder;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.rank.RankLadderCollection;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PVector;
import org.pcollections.TreePVector;
import org.slf4j.Logger;
import org.spongepowered.configurate.util.CheckedFunction;

public class PermissionsEx<P>
implements Consumer<ContextInheritance>,
ContextDefinitionProvider,
PermissionsEngine,
DataStoreContext {
    private final FormattedLogger logger;
    private final Path baseDirectory;
    private final Executor asyncExecutor;
    private final CheckedFunction<String, DataSource, SQLException> dataSourceProvider;
    private final MemoryDataStore transientData;
    private final SubjectType<SubjectType<?>> defaultsType;
    private final SubjectType<SubjectType<?>> fallbacksType;
    private final ConcurrentMap<String, SubjectTypeCollectionImpl<?>> subjectTypeCache = new ConcurrentHashMap();
    private @MonotonicNonNull RankLadderCache rankLadderCache;
    private volatile @Nullable CompletableFuture<ContextInheritance> cachedInheritance;
    private final CacheListenerHolder<Boolean, ContextInheritance> cachedInheritanceListeners = new CacheListenerHolder();
    private final RecordingPermissionCheckNotifier baseNotifier = new RecordingPermissionCheckNotifier();
    private volatile PermissionCheckNotifier notifier = this.baseNotifier;
    private final ConcurrentMap<String, ContextDefinition<?>> contextTypes = new ConcurrentHashMap();
    private final AtomicReference<@Nullable State<P>> state = new AtomicReference();

    public PermissionsEx(Logger logger, Path baseDirectory, Executor asyncExecutor, CheckedFunction<String, @Nullable DataSource, SQLException> databaseProvider) {
        this.logger = WrappingFormattedLogger.of(logger, false);
        this.baseDirectory = baseDirectory;
        this.asyncExecutor = asyncExecutor;
        this.dataSourceProvider = databaseProvider;
        this.registerContextDefinitions(ServerTagContextDefinition.INSTANCE, TimeContextDefinition.BEFORE_TIME, TimeContextDefinition.AFTER_TIME);
        this.defaultsType = this.subjectTypeBuilder("default").transientHasPriority(false).build();
        this.fallbacksType = this.subjectTypeBuilder("fallback").build();
        try {
            this.transientData = (MemoryDataStore)MemoryDataStore.create("transient").defrost((DataStoreContext)this);
        }
        catch (PermissionsLoadingException ex) {
            throw new RuntimeException("Failed to create memory data store!", ex);
        }
    }

    private SubjectType.Builder<SubjectType<?>> subjectTypeBuilder(String id) {
        return SubjectType.builder((String)id, (TypeToken)new TypeToken<SubjectType<?>>(){}).serializedBy(SubjectType::name).deserializedBy(name -> ((SubjectTypeCollectionImpl)this.subjectTypeCache.get(name)).type());
    }

    private State<P> state() throws IllegalStateException {
        @Nullable State<P> ret = this.state.get();
        if (ret == null) {
            throw new IllegalStateException("Manager has already been closed!");
        }
        return ret;
    }

    public SubjectTypeCollection<SubjectType<?>> defaults() {
        return this.subjects((SubjectType)this.defaultsType);
    }

    public SubjectType<SubjectType<?>> defaultsType() {
        return this.defaultsType;
    }

    public SubjectTypeCollection<SubjectType<?>> fallbacks() {
        return this.subjects((SubjectType)this.fallbacksType);
    }

    public SubjectType<SubjectType<?>> fallbacksType() {
        return this.fallbacksType;
    }

    public void registerSubjectTypes(SubjectType<?> ... types) {
        for (SubjectType<?> type : types) {
            this.subjects((SubjectType)type);
        }
    }

    public <I> SubjectTypeCollectionImpl<I> subjects(SubjectType<I> type) {
        SubjectTypeCollectionImpl collection = this.subjectTypeCache.computeIfAbsent(type.name(), key -> {
            SubjectRef defaultIdentifier = SubjectRef.subject(this.defaultsType, (Object)type);
            return new SubjectTypeCollectionImpl(this, type, new SubjectDataCacheImpl(type, defaultIdentifier, ((State)this.state()).activeDataStore), new SubjectDataCacheImpl(type, defaultIdentifier, this.transientData));
        });
        if (!type.equals(collection.type())) {
            throw new IllegalArgumentException("Provided subject type " + type + " is different from registered type " + collection.type());
        }
        return collection;
    }

    public SubjectType<?> subjectType(String id) {
        return ((SubjectTypeCollectionImpl)this.subjectTypeCache.get(id)).type();
    }

    public Collection<SubjectTypeCollectionImpl<?>> loadedSubjectTypes() {
        return Collections.unmodifiableCollection(this.subjectTypeCache.values());
    }

    public Set<SubjectType<?>> knownSubjectTypes() {
        return this.subjectTypeCache.values().stream().map(SubjectTypeCollectionImpl::type).collect(Collectors.toSet());
    }

    public PermissionsEngine engine() {
        return this;
    }

    public SubjectRef<?> deserializeSubjectRef(String type, String name) {
        @Nullable SubjectTypeCollectionImpl existingCollection = (SubjectTypeCollectionImpl)this.subjectTypeCache.get(type);
        if (existingCollection == null) {
            throw new IllegalArgumentException("Unknown subject type " + type);
        }
        return this.deserialize(existingCollection.type(), name);
    }

    public SubjectRef<?> lazySubjectRef(String type, String identifier) {
        return new LazySubjectRef(this, Objects.requireNonNull(type, "type"), Objects.requireNonNull(identifier, "identifier"));
    }

    private <I> SubjectRef<I> deserialize(SubjectType<I> type, String serializedIdent) {
        return SubjectRef.subject(type, (Object)type.parseIdentifier(serializedIdent));
    }

    public <V> CompletableFuture<V> doBulkOperation(Function<DataStore, CompletableFuture<V>> actor) {
        return ((State)this.state()).activeDataStore.performBulkOperation(actor).thenCompose(it -> it);
    }

    public <T> CompletableFuture<T> performBulkOperation(Supplier<CompletableFuture<T>> func) {
        return ((State)this.state()).activeDataStore.performBulkOperation(store -> ((CompletableFuture)func.get()).join());
    }

    public RankLadderCollection ladders() {
        return this.rankLadderCache;
    }

    public CompletableFuture<?> importDataFrom(String dataStoreIdentifier) {
        State<P> state = this.state();
        @Nullable ProtoDataStore<?> expected = ((State)state).config.getDataStore(dataStoreIdentifier);
        if (expected == null) {
            return Util.failedFuture(new IllegalArgumentException("Data store " + dataStoreIdentifier + " is not present"));
        }
        return this.importDataFrom(expected);
    }

    public CompletableFuture<?> importDataFrom(ConversionResult conversion) {
        return this.importDataFrom(conversion.store());
    }

    private CompletableFuture<?> importDataFrom(ProtoDataStore<?> request) {
        DataStore expected;
        State<P> state = this.state();
        try {
            expected = request.defrost((DataStoreContext)this);
        }
        catch (PermissionsLoadingException e) {
            return Util.failedFuture(e);
        }
        return ((State)state).activeDataStore.performBulkOperation(store -> {
            CompletableFuture result = CompletableFuture.allOf((CompletableFuture[])expected.getAll().map(subject -> store.setData((SubjectRef)subject.getKey(), (ImmutableSubjectData)subject.getValue())).toArray(CompletableFuture[]::new));
            result = result.thenCombine(expected.getContextInheritance(null).thenCompose(arg_0 -> ((DataStore)store).setContextInheritance(arg_0)), (a, b) -> a);
            result = expected.getAllRankLadders().map(ladder -> expected.getRankLadder(ladder, null).thenCompose(ladderData -> store.setRankLadder(ladder, ladderData))).reduce(result, (existing, next) -> existing.thenCombine((CompletionStage)next, (v, a) -> null), (one, two) -> one.thenCombine((CompletionStage)two, (v, a) -> null));
            return result;
        }).thenCompose(x -> x);
    }

    public PermissionCheckNotifier getNotifier() {
        return this.notifier;
    }

    public RecordingPermissionCheckNotifier getRecordingNotifier() {
        return this.baseNotifier;
    }

    public boolean debugMode() {
        return this.getNotifier() instanceof DebugPermissionCheckNotifier;
    }

    public synchronized void debugMode(boolean debug, @Nullable Pattern filterPattern) {
        if (debug) {
            this.notifier = this.notifier instanceof DebugPermissionCheckNotifier ? new DebugPermissionCheckNotifier(this.logger(), ((DebugPermissionCheckNotifier)this.notifier).getDelegate(), filterPattern == null ? null : perm -> filterPattern.matcher((CharSequence)perm).find()) : new DebugPermissionCheckNotifier(this.logger(), this.notifier, filterPattern == null ? null : perm -> filterPattern.matcher((CharSequence)perm).find());
        } else if (this.notifier instanceof DebugPermissionCheckNotifier) {
            this.notifier = ((DebugPermissionCheckNotifier)this.notifier).getDelegate();
        }
    }

    private void reloadSync() throws PEBKACException, PermissionsLoadingException {
        try {
            PermissionsExConfiguration config = ((State)this.state()).config.reload();
            config.validate();
            this.prepare(config);
        }
        catch (IOException e) {
            throw new PEBKACException((Component)Messages.CONFIG_ERROR_LOAD.tr(new Object[]{e.getLocalizedMessage()}));
        }
    }

    private void prepare(PermissionsExConfiguration<P> config) throws PermissionsLoadingException {
        this.debugMode(config.isDebugEnabled());
        DataStore newStore = config.getDefaultDataStore().defrost((DataStoreContext)this);
        State newState = new State(config, newStore);
        boolean shouldAnnounceImports = newState.activeDataStore.firstRun();
        try {
            newState.config.save();
        }
        catch (IOException e) {
            throw new PermissionsLoadingException((Component)Messages.CONFIG_ERROR_SAVE.tr(new Object[0]), (Throwable)e);
        }
        if (shouldAnnounceImports) {
            this.logger().warn((Component)Messages.CONVERSION_BANNER.tr(new Object[0]));
        }
        TreePVector allResults = TreePVector.empty();
        for (DataStoreFactory convertable : DataStoreFactory.all().values()) {
            DataStoreFactory.Convertable prov;
            List res;
            if (!(convertable instanceof DataStoreFactory.Convertable) || (res = (prov = (DataStoreFactory.Convertable)convertable).listConversionOptions((PermissionsEngine)this)).isEmpty()) continue;
            if (shouldAnnounceImports) {
                this.logger().info((Component)Messages.CONVERSION_PLUGINHEADER.tr(new Object[]{prov.friendlyName()}));
                for (ConversionResult result : res) {
                    this.logger().info((Component)Messages.CONVERSION_INSTANCE.tr(new Object[]{result.description(), result.store().identifier()}));
                }
            }
            allResults = allResults.plusAll((Collection)res);
        }
        newState.availableConversions = (PVector)allResults;
        @Nullable State<P> oldState = this.state.getAndSet(newState);
        if (oldState != null) {
            try {
                oldState.activeDataStore.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rankLadderCache = new RankLadderCache(this.rankLadderCache, newState.activeDataStore);
        this.subjectTypeCache.forEach((key, val) -> val.update(newState.activeDataStore));
        this.contextTypes.values().forEach(ctxDef -> {
            if (ctxDef instanceof PEXContextDefinition) {
                ((PEXContextDefinition)((Object)ctxDef)).update(newState.config);
            }
        });
        if (this.cachedInheritance != null) {
            this.cachedInheritance = null;
            this.contextInheritance((Consumer<ContextInheritance>)null).thenAccept(inheritance -> this.cachedInheritanceListeners.call(true, (ContextInheritance)inheritance));
        }
        newState.activeDataStore.moveData("system", this.defaultsType.name(), this.defaultsType.name(), this.defaultsType.name()).thenRun(() -> this.logger().info((Component)Messages.CONVERSION_RESULT_SUCCESS.tr(new Object[0])));
    }

    public void initialize(PermissionsExConfiguration<P> config) throws PermissionsLoadingException {
        this.prepare(config);
        this.registerSubjectTypes(this.defaultsType, this.fallbacksType);
    }

    public CompletableFuture<Void> reload() {
        return Util.asyncFailableFuture(() -> {
            this.reloadSync();
            return null;
        }, this.asyncExecutor());
    }

    public void close() {
        @Nullable State state = this.state.getAndSet(null);
        if (state != null) {
            state.activeDataStore.close();
        }
    }

    public List<ConversionResult> getAvailableConversions() {
        return ((State)this.state()).availableConversions;
    }

    public FormattedLogger logger() {
        return this.logger;
    }

    public Path baseDirectory() {
        return this.baseDirectory;
    }

    @Deprecated
    public @Nullable DataSource dataSourceForUrl(String url) throws SQLException {
        return (DataSource)this.dataSourceProvider.apply((Object)url);
    }

    public Executor asyncExecutor() {
        return this.asyncExecutor;
    }

    public String version() {
        return PermissionsEx.class.getPackage().getImplementationVersion();
    }

    public PermissionsExConfiguration<P> config() {
        return ((State)this.state()).config;
    }

    public DataStore activeDataStore() {
        return ((State)this.state()).activeDataStore;
    }

    public CompletableFuture<ContextInheritance> contextInheritance(@Nullable Consumer<ContextInheritance> listener) {
        if (this.cachedInheritance == null) {
            this.cachedInheritance = ((State)this.state()).activeDataStore.getContextInheritance((Consumer)this);
        }
        if (listener != null) {
            this.cachedInheritanceListeners.addListener(true, listener);
        }
        return this.cachedInheritance;
    }

    public CompletableFuture<ContextInheritance> contextInheritance(ContextInheritance newInheritance) {
        return ((State)this.state()).activeDataStore.setContextInheritance(newInheritance);
    }

    @Override
    public void accept(ContextInheritance newData) {
        this.cachedInheritance = CompletableFuture.completedFuture(newData);
        this.cachedInheritanceListeners.call(true, newData);
    }

    public CompletableFuture<Set<ContextDefinition<?>>> usedContextTypes() {
        return ((State)this.state()).activeDataStore.getDefinedContextKeys().thenCombine(this.transientData.getDefinedContextKeys(), (persist, trans) -> {
            HashSet<ContextDefinition> build = new HashSet<ContextDefinition>();
            for (ContextDefinition def : this.contextTypes.values()) {
                if (!persist.contains(def.name()) && !trans.contains(def.name())) continue;
                build.add(def);
            }
            return Collections.unmodifiableSet(build);
        });
    }

    public <T> boolean registerContextDefinition(ContextDefinition<T> contextDefinition) {
        ContextDefinition<T> possibleOut;
        if (contextDefinition instanceof PEXContextDefinition && this.state.get() != null) {
            ((PEXContextDefinition)contextDefinition).update(this.config());
        }
        if ((possibleOut = this.contextTypes.putIfAbsent(contextDefinition.name(), contextDefinition)) instanceof SimpleContextDefinition.Fallback) {
            return this.contextTypes.replace(contextDefinition.name(), possibleOut, contextDefinition);
        }
        return possibleOut == null;
    }

    public int registerContextDefinitions(ContextDefinition<?> ... definitions) {
        int numRegistered = 0;
        for (ContextDefinition<?> def : definitions) {
            if (!this.registerContextDefinition(def)) continue;
            ++numRegistered;
        }
        return numRegistered;
    }

    public List<ContextDefinition<?>> registeredContextTypes() {
        return PCollections.asVector(this.contextTypes.values());
    }

    public @Nullable ContextDefinition<?> contextDefinition(String definitionKey, boolean allowFallbacks) {
        SimpleContextDefinition.Fallback fallback;
        @Nullable ContextDefinition ret = (ContextDefinition)this.contextTypes.get(definitionKey);
        if (ret == null && allowFallbacks && (ret = (ContextDefinition)this.contextTypes.putIfAbsent(definitionKey, (ContextDefinition<?>)(fallback = new SimpleContextDefinition.Fallback(definitionKey)))) == null) {
            ret = fallback;
        }
        return ret;
    }

    private static class State<P> {
        private final PermissionsExConfiguration<P> config;
        private final DataStore activeDataStore;
        private PVector<ConversionResult> availableConversions = TreePVector.empty();

        private State(PermissionsExConfiguration<P> config, DataStore activeDataStore) {
            this.config = config;
            this.activeDataStore = activeDataStore;
        }
    }
}

