/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.backend.AbstractDataStore;
import ca.stellardrift.permissionsex.impl.backend.file.FileSubjectData;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.impl.backend.file.SchemaMigrations;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryContextInheritance;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.config.SubjectRefSerializer;
import ca.stellardrift.permissionsex.impl.rank.FixedRankLadder;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.util.MapFactories;
import org.spongepowered.configurate.util.UnmodifiableCollections;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class FileDataStore
extends AbstractDataStore<FileDataStore, Config> {
    static final String KEY_RANK_LADDERS = "rank-ladders";
    private @Nullable WatchServiceListener reloadService;
    private @MonotonicNonNull ConfigurationReference<BasicConfigurationNode> permissionsConfig;
    private final AtomicInteger saveSuppressed = new AtomicInteger();
    private final AtomicBoolean dirty = new AtomicBoolean();

    public FileDataStore(DataStoreContext context, ProtoDataStore<Config> properties) {
        super(context, properties);
    }

    private ConfigurationReference<BasicConfigurationNode> createLoader(Path file) throws ConfigurateException {
        Function<Path, ConfigurationLoader> loaderFunc = path -> ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().defaultOptions(o -> {
            o = o.serializers(s -> FilePermissionsExConfiguration.populateSerializers(s).register(SubjectRefSerializer.TYPE, (TypeSerializer)new SubjectRefSerializer(this.context(), null)));
            if (((Config)this.config()).alphabetizeEntries) {
                return o.mapFactory(MapFactories.sortedNatural());
            }
            return o;
        })).path(path)).indent(4).lenient(true).build();
        ConfigurationReference ret = this.reloadService != null ? this.reloadService.listenToConfiguration(loaderFunc, file) : ConfigurationReference.fixed((ConfigurationLoader)loaderFunc.apply(file));
        ret.updates().subscribe(this::refresh);
        ret.errors().subscribe(e -> this.context().logger().error((Component)Messages.FILE_ERROR_AUTORELOAD.tr(new Object[]{e.getKey(), ((Throwable)e.getValue()).getLocalizedMessage()})));
        return ret;
    }

    private void refresh(ConfigurationNode newNode) {
        this.listeners.getAllKeys().forEach(key -> {
            try {
                this.listeners.call(key, this.getDataSync((String)key.getKey(), (String)key.getValue()));
            }
            catch (PermissionsLoadingException e) {
                this.context().logger().error((Component)Messages.FILE_ERROR_SUBJECT_AUTORELOAD.tr(new Object[]{key.getKey(), key.getValue()}));
            }
        });
        this.rankLadderListeners.getAllKeys().forEach(key -> this.rankLadderListeners.call(key, this.getRankLadderInternal((String)key).join()));
        this.contextInheritanceListeners.getAllKeys().forEach(key -> this.contextInheritanceListeners.call(key, this.getContextInheritanceInternal().join()));
        this.context().logger().info((Component)Messages.FILE_RELOAD_AUTO.tr(new Object[]{((Config)this.config()).file}));
    }

    private Path migrateLegacy(Path permissionsFile, String extension, ConfigurationLoader<?> legacyLoader, String formatName) throws PermissionsLoadingException {
        Path legacyPermissionsFile = permissionsFile;
        ((Config)this.config()).file = ((Config)this.config()).file.replace(extension, ".json");
        permissionsFile = this.context().baseDirectory().resolve(((Config)this.config()).file);
        try {
            this.permissionsConfig = this.createLoader(permissionsFile);
            this.permissionsConfig.save(legacyLoader.load());
            Files.move(legacyPermissionsFile, legacyPermissionsFile.resolveSibling(legacyPermissionsFile.getFileName().toString() + ".legacy-backup"), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new PermissionsLoadingException((Component)Messages.FILE_ERROR_LEGACY_MIGRATION.tr(new Object[]{formatName, legacyPermissionsFile}), (Throwable)e);
        }
        return permissionsFile;
    }

    @Override
    protected void load() throws PermissionsLoadingException {
        if (((Config)this.config()).autoReload) {
            try {
                this.reloadService = WatchServiceListener.builder().taskExecutor(this.context().asyncExecutor()).build();
            }
            catch (IOException e) {
                throw new PermissionsLoadingException((Throwable)e);
            }
        }
        String rawFile = ((Config)this.config()).file;
        Path permissionsFile = this.context().baseDirectory().resolve(rawFile);
        if (rawFile.endsWith(".yml")) {
            permissionsFile = this.migrateLegacy(permissionsFile, ".yml", (ConfigurationLoader<?>)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(permissionsFile)).build(), "YML");
        } else if (rawFile.endsWith(".conf")) {
            permissionsFile = this.migrateLegacy(permissionsFile, ".conf", (ConfigurationLoader<?>)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(permissionsFile)).build(), "HOCON");
        } else {
            try {
                this.permissionsConfig = this.createLoader(permissionsFile);
            }
            catch (ConfigurateException e) {
                throw new PermissionsLoadingException((Component)Messages.FILE_ERROR_LOAD.tr(new Object[]{permissionsFile}), (Throwable)e);
            }
        }
        if (((BasicConfigurationNode)this.permissionsConfig.node()).childrenMap().isEmpty()) {
            try {
                this.performBulkOperationSync((Function)input -> {
                    this.applyDefaultData();
                    ((BasicConfigurationNode)this.permissionsConfig.get(new Object[]{"schema-version"})).raw((Object)4);
                    return null;
                });
            }
            catch (PermissionsLoadingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PermissionsLoadingException((Component)Messages.FILE_ERROR_INITIAL_DATA.tr(new Object[0]), (Throwable)e);
            }
            this.markFirstRun();
        } else {
            try {
                ConfigurationTransformation versionUpdater = SchemaMigrations.versionedMigration(this.context().logger());
                int startVersion = ((BasicConfigurationNode)this.permissionsConfig.get(new Object[]{"schema-version"})).getInt(-1);
                ConfigurationNode node = this.permissionsConfig.node();
                versionUpdater.apply(node);
                int endVersion = ((BasicConfigurationNode)this.permissionsConfig.get(new Object[]{"schema-version"})).getInt();
                if (endVersion > startVersion) {
                    this.context().logger().info((Component)Messages.FILE_SCHEMA_MIGRATION_SUCCESS.tr(new Object[]{permissionsFile, startVersion, endVersion}));
                    this.permissionsConfig.save(node);
                }
            }
            catch (ConfigurateException ex) {
                throw new PermissionsLoadingException((Component)Messages.FILE_ERROR_SCHEMA_MIGRATION_SAVE.tr(new Object[0]), (Throwable)ex);
            }
        }
    }

    public void close() {
        if (this.reloadService != null) {
            try {
                this.reloadService.close();
            }
            catch (IOException e) {
                this.context().logger().error("Unable to shut down FileDataStore watch service", (Throwable)e);
            }
            this.reloadService = null;
        }
    }

    private ConfigurationNode getSubjectsNode() {
        return this.permissionsConfig.get(new Object[]{"subjects"});
    }

    private CompletableFuture<Void> save() {
        if (this.saveSuppressed.get() <= 0) {
            return Util.asyncFailableFuture(() -> {
                this.saveSync();
                return null;
            }, this.context().asyncExecutor());
        }
        return CompletableFuture.completedFuture(null);
    }

    private void saveSync() throws ConfigurateException {
        if (this.saveSuppressed.get() <= 0 && this.dirty.compareAndSet(true, false)) {
            this.permissionsConfig.save();
        }
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> getDataInternal(String type, String identifier) {
        try {
            return CompletableFuture.completedFuture(this.getDataSync(type, identifier));
        }
        catch (PermissionsLoadingException e) {
            return Util.failedFuture(e);
        }
    }

    private ImmutableSubjectData getDataSync(String type, String identifier) throws PermissionsLoadingException {
        try {
            return FileSubjectData.fromNode(this.getSubjectsNode().node(new Object[]{type, identifier}));
        }
        catch (SerializationException e) {
            throw new PermissionsLoadingException((Component)Messages.FILE_ERROR_DESERIALIZE_SUBJECT.tr(new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected CompletableFuture<ImmutableSubjectData> setDataInternal(String type, String identifier, @Nullable ImmutableSubjectData data) {
        try {
            if (data == null) {
                this.getSubjectsNode().node(new Object[]{type, identifier}).raw(null);
                this.dirty.set(true);
                return this.save().thenApply(input -> null);
            }
            FileSubjectData fileData = data instanceof FileSubjectData ? (FileSubjectData)data : (FileSubjectData)new FileSubjectData().mergeFrom(data);
            fileData.serialize(this.getSubjectsNode().node(new Object[]{type, identifier}));
            this.dirty.set(true);
            return this.save().thenApply(none -> fileData);
        }
        catch (SerializationException e) {
            return Util.failedFuture(e);
        }
    }

    public CompletableFuture<Boolean> isRegistered(String type, String identifier) {
        return CompletableFuture.completedFuture(!this.getSubjectsNode().node(new Object[]{type, identifier}).virtual());
    }

    public Stream<String> getAllIdentifiers(String type) {
        return this.getSubjectsNode().node(new Object[]{type}).childrenMap().keySet().stream().map(Objects::toString);
    }

    public Set<String> getRegisteredTypes() {
        return Collections.unmodifiableSet(this.getSubjectsNode().childrenMap().entrySet().stream().filter(ent -> ((ConfigurationNode)ent.getValue()).isMap()).map(Map.Entry::getKey).map(Object::toString).collect(Collectors.toSet()));
    }

    public CompletableFuture<Set<String>> getDefinedContextKeys() {
        return CompletableFuture.completedFuture((Set)this.getSubjectsNode().childrenMap().values().stream().flatMap(typeNode -> typeNode.childrenMap().values().stream()).flatMap(subjectNode -> subjectNode.childrenList().stream()).flatMap(segmentNode -> segmentNode.node(new Object[]{"contexts"}).childrenMap().entrySet().stream()).map(ctx -> ctx.getKey().toString()).collect(PCollections.toPSet()));
    }

    public Stream<Map.Entry<SubjectRef<?>, ImmutableSubjectData>> getAll() {
        return this.getSubjectsNode().childrenMap().keySet().stream().flatMap(type -> {
            String typeStr = type.toString();
            return this.getAll(typeStr).map(pair -> UnmodifiableCollections.immutableMapEntry((Object)this.context().deserializeSubjectRef(typeStr, (String)pair.getKey()), (Object)((ImmutableSubjectData)pair.getValue())));
        });
    }

    private ConfigurationNode getRankLaddersNode() {
        return this.permissionsConfig.get(new Object[]{KEY_RANK_LADDERS});
    }

    public Stream<String> getAllRankLadders() {
        return this.getRankLaddersNode().childrenMap().keySet().stream().map(Object::toString);
    }

    @Override
    public CompletableFuture<RankLadder> getRankLadderInternal(String ladder) {
        return CompletableFuture.completedFuture(new FixedRankLadder(ladder, (List)this.getRankLaddersNode().node(new Object[]{ladder.toLowerCase()}).childrenList().stream().map(node -> {
            try {
                return (SubjectRef)node.get(SubjectRef.TYPE);
            }
            catch (SerializationException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(PCollections.toPVector())));
    }

    public CompletableFuture<Boolean> hasRankLadder(String ladder) {
        return CompletableFuture.completedFuture(!this.getRankLaddersNode().node(new Object[]{ladder.toLowerCase()}).virtual());
    }

    @Override
    public CompletableFuture<ContextInheritance> getContextInheritanceInternal() {
        try {
            return CompletableFuture.completedFuture((ContextInheritance)((BasicConfigurationNode)this.permissionsConfig.node()).get(MemoryContextInheritance.class));
        }
        catch (SerializationException e) {
            return Util.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance inheritance) {
        MemoryContextInheritance realInheritance = MemoryContextInheritance.fromExistingContextInheritance(inheritance);
        try {
            ((BasicConfigurationNode)this.permissionsConfig.node()).set(MemoryContextInheritance.class, (Object)realInheritance);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        this.dirty.set(true);
        return this.save().thenApply(none -> realInheritance);
    }

    @Override
    public CompletableFuture<RankLadder> setRankLadderInternal(String identifier, @Nullable RankLadder ladder) {
        ConfigurationNode childNode = this.getRankLaddersNode().node(new Object[]{identifier.toLowerCase()});
        try {
            childNode.raw(null);
            if (ladder != null) {
                for (SubjectRef rank : ladder.ranks()) {
                    childNode.appendListNode().set(SubjectRef.TYPE, (Object)rank);
                }
            }
        }
        catch (SerializationException ex) {
            return Util.failedFuture(ex);
        }
        this.dirty.set(true);
        return this.save().thenApply(none -> ladder);
    }

    @Override
    protected <T> T performBulkOperationSync(Function<DataStore, T> function) throws Exception {
        T ret;
        this.saveSuppressed.getAndIncrement();
        try {
            ret = function.apply(this);
        }
        finally {
            this.saveSuppressed.getAndDecrement();
        }
        this.saveSync();
        return ret;
    }

    @AutoService(value={DataStoreFactory.class})
    public static class Factory
    extends AbstractDataStore.Factory<FileDataStore, Config> {
        public Factory() {
            super("file", Config.class, FileDataStore::new);
        }
    }

    @ConfigSerializable
    static class Config {
        @Setting
        String file;
        @Setting
        @Comment(value="Place file entries in alphabetical order")
        boolean alphabetizeEntries = false;
        @Setting
        @Comment(value="Automatically reload the data file when changes have been made")
        boolean autoReload = true;

        Config() {
        }
    }
}

