/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.memory;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.backend.AbstractDataStore;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryContextInheritance;
import ca.stellardrift.permissionsex.impl.backend.memory.MemorySubjectData;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.rank.FixedRankLadder;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public class MemoryDataStore
extends AbstractDataStore<MemoryDataStore, Config> {
    private final ConcurrentMap<Map.Entry<String, String>, ImmutableSubjectData> data = new ConcurrentHashMap<Map.Entry<String, String>, ImmutableSubjectData>();
    private final ConcurrentMap<String, RankLadder> rankLadders = new ConcurrentHashMap<String, RankLadder>();
    private volatile ContextInheritance inheritance = new MemoryContextInheritance();

    public static ProtoDataStore<?> create(String identifier) {
        try {
            return DataStoreFactory.forType((String)"memory").create(identifier, (ConfigurationNode)BasicConfigurationNode.root((ConfigurationOptions)FilePermissionsExConfiguration.PEX_OPTIONS));
        }
        catch (PermissionsLoadingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MemoryDataStore(DataStoreContext context, ProtoDataStore<Config> properties) {
        super(context, properties);
    }

    @Override
    protected void load() {
        this.markFirstRun();
    }

    public void close() {
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> getDataInternal(String type, String identifier) {
        Map.Entry key = UnmodifiableCollections.immutableMapEntry((Object)type, (Object)identifier);
        ImmutableSubjectData ret = (ImmutableSubjectData)this.data.get(key);
        if (ret == null) {
            ImmutableSubjectData existingData;
            ret = new MemorySubjectData();
            if (((Config)this.config()).track && (existingData = this.data.putIfAbsent(key, ret)) != null) {
                ret = existingData;
            }
        }
        return this.completedFuture(ret);
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> setDataInternal(String type, String identifier, ImmutableSubjectData data) {
        if (((Config)this.config()).track) {
            this.data.put(UnmodifiableCollections.immutableMapEntry((Object)type, (Object)identifier), data);
        }
        return this.completedFuture(data);
    }

    @Override
    protected CompletableFuture<RankLadder> getRankLadderInternal(String name) {
        RankLadder ladder = (RankLadder)this.rankLadders.get(name.toLowerCase());
        if (ladder == null) {
            ladder = new FixedRankLadder(name, (List<SubjectRef<?>>)PCollections.vector());
        }
        return this.completedFuture(ladder);
    }

    @Override
    protected CompletableFuture<RankLadder> setRankLadderInternal(String ladder, @Nullable RankLadder newLadder) {
        if (newLadder == null) {
            this.rankLadders.remove(ladder);
        } else {
            this.rankLadders.put(ladder, newLadder);
        }
        return this.completedFuture(newLadder);
    }

    private <T> CompletableFuture<T> completedFuture(T i) {
        return CompletableFuture.supplyAsync(() -> i, this.context().asyncExecutor());
    }

    public CompletableFuture<Boolean> isRegistered(String type, String identifier) {
        return this.completedFuture(this.data.containsKey(UnmodifiableCollections.immutableMapEntry((Object)type, (Object)identifier)));
    }

    public Stream<String> getAllIdentifiers(String type) {
        return this.data.keySet().stream().filter(inp -> ((String)inp.getKey()).equals(type)).map(Map.Entry::getValue);
    }

    public Set<String> getRegisteredTypes() {
        return (Set)this.data.keySet().stream().map(Map.Entry::getKey).collect(PCollections.toPSet());
    }

    public CompletableFuture<Set<String>> getDefinedContextKeys() {
        return CompletableFuture.completedFuture(this.data.values().stream().flatMap(data -> data.activeContexts().stream()).flatMap(Collection::stream).map(ContextValue::key).collect(Collectors.toSet()));
    }

    public Stream<Map.Entry<SubjectRef<?>, ImmutableSubjectData>> getAll() {
        return this.data.entrySet().stream().map(entry -> UnmodifiableCollections.immutableMapEntry((Object)this.context().deserializeSubjectRef((Map.Entry)entry.getKey()), (Object)((ImmutableSubjectData)entry.getValue())));
    }

    public Stream<String> getAllRankLadders() {
        return this.rankLadders.keySet().stream();
    }

    public CompletableFuture<Boolean> hasRankLadder(String ladder) {
        return this.completedFuture(this.rankLadders.containsKey(ladder.toLowerCase()));
    }

    @Override
    public CompletableFuture<ContextInheritance> getContextInheritanceInternal() {
        return this.completedFuture(this.inheritance);
    }

    @Override
    public CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance inheritance) {
        this.inheritance = inheritance;
        return this.completedFuture(this.inheritance);
    }

    @Override
    protected <T> T performBulkOperationSync(Function<DataStore, T> function) {
        return function.apply(this);
    }

    @AutoService(value={DataStoreFactory.class})
    public static final class Factory
    extends AbstractDataStore.Factory<MemoryDataStore, Config> {
        static final String TYPE = "memory";

        public Factory() {
            super(TYPE, Config.class, MemoryDataStore::new);
        }
    }

    @ConfigSerializable
    static class Config {
        @Setting
        @Comment(value="Whether or not this data store will store subjects being set")
        boolean track = true;

        Config() {
        }
    }
}

