/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PCollection;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.Types;

final class PCollectionSerializer<T extends PCollection<?>>
implements TypeSerializer<T> {
    private final Supplier<T> emptySupplier;

    PCollectionSerializer(Supplier<T> emptySupplier) {
        this.emptySupplier = emptySupplier;
    }

    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List values = node.childrenList();
            PCollection ret = (PCollection)this.emptySupplier.get();
            for (ConfigurationNode value : values) {
                try {
                    ret = ret.plus(entrySerial.deserialize(entryType, value));
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)value).path());
                    throw ex;
                }
            }
            return (T)ret;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            return (T)((PCollection)this.emptySupplier.get()).plus(entrySerial.deserialize(entryType, node));
        }
        return (T)((PCollection)this.emptySupplier.get());
    }

    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            for (Object el : obj) {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)child).path());
                    throw ex;
                }
            }
        }
    }

    public T emptyValue(Type specificType, ConfigurationOptions options) {
        return (T)((PCollection)this.emptySupplier.get());
    }

    private Type elementType(Type containerType) {
        Types.requireCompleteParameters((Type)containerType);
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }
}

