/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import com.google.errorprone.annotations.concurrent.LazyInit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LazySubjectRef
implements SubjectRef<Object> {
    private final PermissionsEx<?> pex;
    private final String type;
    private final String ident;
    @LazyInit
    private @MonotonicNonNull SubjectRef<?> resolved;

    public LazySubjectRef(PermissionsEx<?> pex, String type, String ident) {
        this.pex = pex;
        this.type = type;
        this.ident = ident;
    }

    public SubjectType<Object> type() {
        return this.resolved().type();
    }

    public Object identifier() {
        return this.resolved().serializedIdentifier();
    }

    public String serializedType() {
        return this.type;
    }

    public String serializedIdentifier() {
        @Nullable SubjectRef<?> resolved = this.resolved;
        if (resolved != null) {
            return resolved.serializedIdentifier();
        }
        return this.ident;
    }

    public SubjectRef<?> resolved() {
        if (this.resolved != null) {
            return this.resolved;
        }
        this.resolved = this.pex.deserializeSubjectRef(this.type, this.ident);
        return this.resolved;
    }

    public int hashCode() {
        return this.resolved().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LazySubjectRef) {
            LazySubjectRef that = (LazySubjectRef)other;
            if (this.resolved != null || that.resolved != null) {
                return this.resolved().equals(that.resolved());
            }
            return this.type.equals(that.type) && this.ident.equals(that.ident);
        }
        if (other instanceof SubjectRef) {
            return this.resolved().equals(other);
        }
        return false;
    }

    public String toString() {
        return "LazySubjectRef{type=" + this.type + ", identifier=" + this.ident + ", resolved=" + this.resolved + '}';
    }
}

