/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.impl.subject.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.impl.util.CacheListenerHolder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import ca.stellardrift.permissionsex.subject.SubjectDataCache;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SubjectDataCacheImpl<I>
implements SubjectDataCache<I> {
    private final SubjectType<I> type;
    @LazyInit
    private DataStore dataStore;
    private final AtomicReference<AsyncLoadingCache<I, ImmutableSubjectData>> cache = new AtomicReference();
    private final Map<I, Consumer<ImmutableSubjectData>> cacheHolders = new ConcurrentHashMap<I, Consumer<ImmutableSubjectData>>();
    private final CacheListenerHolder<I, ImmutableSubjectData> listeners;
    private final SubjectRef<SubjectType<?>> defaultIdentifier;

    public SubjectDataCacheImpl(SubjectType<I> type, SubjectRef<SubjectType<?>> defaultIdentifier, DataStore dataStore) {
        this.type = type;
        this.update(dataStore);
        this.defaultIdentifier = defaultIdentifier;
        this.listeners = new CacheListenerHolder();
    }

    @EnsuresNonNull(value={"this.dataStore"})
    public void update(DataStore newDataStore) {
        this.dataStore = newDataStore;
        AsyncLoadingCache oldCache = this.cache.getAndSet(Caffeine.newBuilder().maximumSize(512L).buildAsync((key, executor) -> this.dataStore.getData(this.type.name(), this.type.serializeIdentifier(key), this.clearListener(key))));
        if (oldCache != null) {
            oldCache.synchronous().asMap().forEach((k, v) -> this.data(k, null).thenAccept(data -> this.listeners.call((I)k, (ImmutableSubjectData)data)));
        }
    }

    public CompletableFuture<ImmutableSubjectData> data(I identifier, @Nullable Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture ret = this.cache.get().get(identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(identifier, listener);
            }
        });
        return ret;
    }

    public CompletableFuture<ToDataSubjectRefImpl<I>> referenceTo(I identifier) {
        return this.referenceTo(identifier, true);
    }

    public CompletableFuture<ToDataSubjectRefImpl<I>> referenceTo(I identifier, boolean strongListeners) {
        ToDataSubjectRefImpl ref = new ToDataSubjectRefImpl(identifier, this, strongListeners);
        return this.data(identifier, ref).thenApply(data -> {
            ref.data.set((ImmutableSubjectData)data);
            return ref;
        });
    }

    public CompletableFuture<ImmutableSubjectData> update(I identifier, UnaryOperator<ImmutableSubjectData> action) {
        return this.data(identifier, null).thenCompose(data -> {
            ImmutableSubjectData newData = (ImmutableSubjectData)action.apply((ImmutableSubjectData)data);
            if (data != newData) {
                return this.set(identifier, newData);
            }
            return CompletableFuture.completedFuture(data);
        });
    }

    public void load(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.get().get(identifier);
    }

    public void invalidate(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.get().synchronous().invalidate(identifier);
        this.cacheHolders.remove(identifier);
        this.listeners.removeAll(identifier);
    }

    public void cacheAll() {
        this.dataStore.getAllIdentifiers(this.type.name()).forEach(ident -> {
            try {
                this.cache.get().synchronous().refresh(this.type.parseIdentifier(ident));
            }
            catch (InvalidIdentifierException invalidIdentifierException) {
                // empty catch block
            }
        });
    }

    public CompletableFuture<Boolean> isRegistered(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.isRegistered(this.type.name(), this.type.serializeIdentifier(identifier));
    }

    public CompletableFuture<ImmutableSubjectData> remove(I identifier) {
        return this.set(identifier, null);
    }

    public CompletableFuture<ImmutableSubjectData> set(I identifier, @Nullable ImmutableSubjectData newData) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.setData(this.type.name(), this.type.serializeIdentifier(identifier), newData);
    }

    private Consumer<ImmutableSubjectData> clearListener(I name) {
        Consumer<ImmutableSubjectData> ret = newData -> {
            this.cache.get().put(name, CompletableFuture.completedFuture(newData));
            this.listeners.call(name, (ImmutableSubjectData)newData);
        };
        this.cacheHolders.put(name, ret);
        return ret;
    }

    public void addListener(I identifier, Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(listener, "listener");
        this.listeners.addListener(identifier, listener);
    }

    public SubjectType<I> type() {
        return this.type;
    }

    public Stream<I> getAllIdentifiers() {
        return this.dataStore.getAllIdentifiers(this.type.name()).map(arg_0 -> this.type.parseIdentifier(arg_0));
    }

    public SubjectRef<SubjectType<?>> getDefaultIdentifier() {
        return this.defaultIdentifier;
    }
}

