/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.PermissionsEngineBuilder;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.Messages;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.util.CheckedFunction;
import org.spongepowered.configurate.util.UnmodifiableCollections;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class PermissionsExBuilder<C>
implements PermissionsEngineBuilder<C> {
    final Class<C> configType;
    @Nullable Path configFile;
    @Nullable Path baseDirectory;
    @Nullable Logger logger;
    @Nullable Executor asyncExecutor;
    CheckedFunction<String, @Nullable DataSource, SQLException> databaseProvider = $ -> null;

    PermissionsExBuilder(Class<C> configType) {
        this.configType = configType;
    }

    public PermissionsEngineBuilder<C> configuration(Path configFile) {
        this.configFile = configFile;
        return this;
    }

    public PermissionsEngineBuilder<C> baseDirectory(Path baseDir) {
        this.baseDirectory = baseDir;
        return this;
    }

    public PermissionsEngineBuilder<C> logger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
        return this;
    }

    public PermissionsEngineBuilder<C> asyncExecutor(Executor executor) {
        this.asyncExecutor = Objects.requireNonNull(executor, "executor");
        return this;
    }

    public PermissionsEngineBuilder<C> databaseProvider(CheckedFunction<String, @Nullable DataSource, SQLException> databaseProvider) {
        this.databaseProvider = Objects.requireNonNull(databaseProvider, "databaseProvider");
        return this;
    }

    public PermissionsEx<?> build() throws PermissionsLoadingException {
        return (PermissionsEx)this.buildWithConfig().getKey();
    }

    public Map.Entry<PermissionsEngine, Supplier<C>> buildWithConfig() throws PermissionsLoadingException {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)"PermissionsEx");
        }
        if (this.asyncExecutor == null) {
            this.asyncExecutor = ForkJoinPool.commonPool();
        }
        if (this.configFile == null) {
            throw new PermissionsLoadingException((Component)Component.text((String)"Configuration file has not been set"));
        }
        if (this.baseDirectory == null) {
            this.baseDirectory = Paths.get(".", new String[0]);
        }
        FilePermissionsExConfiguration<C> config = this.makeConfiguration(this.configFile);
        PermissionsEx<C> engine = new PermissionsEx<C>(this.logger, this.baseDirectory, this.asyncExecutor, this.databaseProvider);
        engine.initialize(config);
        return UnmodifiableCollections.immutableMapEntry(engine, engine.config()::getPlatformConfig);
    }

    private FilePermissionsExConfiguration<C> makeConfiguration(Path configFile) throws PermissionsLoadingException {
        YamlConfigurationLoader loader;
        String fileName = configFile.getFileName().toString();
        if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
            loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configFile)).nodeStyle(NodeStyle.BLOCK).defaultOptions(FilePermissionsExConfiguration.PEX_OPTIONS)).build();
        } else if (fileName.endsWith(".conf") || fileName.endsWith(".hocon")) {
            loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configFile)).defaultOptions(FilePermissionsExConfiguration.PEX_OPTIONS)).build();
        } else if (fileName.endsWith(".json")) {
            loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().indent(2).defaultOptions(FilePermissionsExConfiguration.PEX_OPTIONS)).build();
        } else {
            throw new PermissionsLoadingException((Component)Messages.CONFIG_ERROR_UNKNOWN_FORMAT.tr(new Object[]{fileName}));
        }
        try {
            return FilePermissionsExConfiguration.fromLoader(loader, this.configType);
        }
        catch (ConfigurateException ex) {
            throw new PermissionsLoadingException((Component)Messages.CONFIG_ERROR_LOAD.tr(new Object[]{ex}));
        }
    }

    @AutoService(value={PermissionsEngineBuilder.Factory.class})
    public static class Factory
    implements PermissionsEngineBuilder.Factory {
        public <C> PermissionsEngineBuilder<C> newBuilder(Class<C> configType) {
            return new PermissionsExBuilder<C>(configType);
        }
    }
}

