/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.impl.backend.memory.MemorySubjectData;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public final class FileSubjectData
extends MemorySubjectData {
    static final String KEY_CONTEXTS = "contexts";

    static FileSubjectData fromNode(ConfigurationNode node) throws SerializationException, PermissionsLoadingException {
        PMap map = PCollections.map();
        if (node.isList()) {
            for (ConfigurationNode child : node.childrenList()) {
                if (!child.isMap()) {
                    throw new PermissionsLoadingException((Component)Messages.FILE_LOAD_CONTEXT.tr(new Object[0]));
                }
                PSet<ContextValue<?>> contexts = FileSubjectData.contextsFrom(child);
                MemorySubjectData.MemorySegment value = (MemorySubjectData.MemorySegment)MAPPER.load(child);
                map = map.plus(contexts, (Object)value);
            }
        }
        return new FileSubjectData(map);
    }

    FileSubjectData() {
    }

    FileSubjectData(PMap<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment> contexts) {
        super((Map<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment>)contexts);
    }

    @Override
    protected MemorySubjectData newData(PMap<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment> contexts) {
        return new FileSubjectData(contexts);
    }

    private static PSet<ContextValue<?>> contextsFrom(ConfigurationNode node) {
        PSet contexts = PCollections.set();
        ConfigurationNode contextsNode = node.node(new Object[]{KEY_CONTEXTS});
        if (contextsNode.isMap()) {
            contexts = contextsNode.childrenMap().entrySet().stream().map(ent -> new ContextValue(ent.getKey().toString(), ((ConfigurationNode)ent.getValue()).getString())).collect(PCollections.toPSet());
        }
        return contexts;
    }

    void serialize(ConfigurationNode node) throws SerializationException {
        if (!node.isList()) {
            node.raw(null);
        }
        HashMap existingSections = new HashMap();
        for (ConfigurationNode child : node.childrenList()) {
            existingSections.put(FileSubjectData.contextsFrom(child), child);
        }
        for (Map.Entry ent : this.segments.entrySet()) {
            ConfigurationNode contextSection = (ConfigurationNode)existingSections.remove(ent.getKey());
            if (contextSection == null) {
                contextSection = node.appendListNode();
                ConfigurationNode contextsNode = contextSection.node(new Object[]{KEY_CONTEXTS});
                for (ContextValue context : (PSet)ent.getKey()) {
                    contextsNode.node(new Object[]{context.key()}).set((Object)context.rawValue());
                }
            }
            MAPPER.save((Object)((MemorySubjectData.MemorySegment)ent.getValue()), contextSection);
        }
        for (ConfigurationNode unused : existingSections.values()) {
            unused.raw(null);
        }
    }

    @Override
    public String toString() {
        return "FileSubjectData{segments=" + this.segments + '}';
    }
}

