/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.memory;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.Segment;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.serialize.SerializationException;

public class MemorySubjectData
implements ImmutableSubjectData {
    protected static final ObjectMapper<MemorySegment> MAPPER;
    protected final PMap<PSet<ContextValue<?>>, MemorySegment> segments;

    protected MemorySubjectData() {
        this.segments = PCollections.map();
    }

    protected MemorySubjectData(Map<PSet<ContextValue<?>>, MemorySegment> segments) {
        this.segments = PCollections.asMap(segments);
    }

    protected MemorySubjectData newData(PMap<PSet<ContextValue<?>>, MemorySegment> contexts) {
        if (contexts == this.segments) {
            return this;
        }
        return new MemorySubjectData((Map<PSet<ContextValue<?>>, MemorySegment>)contexts);
    }

    public Map<Set<ContextValue<?>>, Segment> segments() {
        return this.segments;
    }

    public ImmutableSubjectData withSegments(BiFunction<Set<ContextValue<?>>, Segment, Segment> transformer) {
        PMap output = this.segments;
        for (Map.Entry entry : this.segments.entrySet()) {
            MemorySegment mapped = MemorySegment.from(transformer.apply((Set)entry.getKey(), (Segment)entry.getValue()));
            if (mapped == entry.getValue()) continue;
            if (mapped.empty()) {
                output = output.minus(entry.getKey());
                continue;
            }
            output = output.plus((Object)((PSet)entry.getKey()), (Object)mapped);
        }
        return this.newData(output);
    }

    public ImmutableSubjectData withSegment(Set<ContextValue<?>> contexts, UnaryOperator<Segment> operation) {
        Segment original;
        PSet<ContextValue<?>> pContexts = PCollections.asSet(contexts);
        MemorySegment mapped = MemorySegment.from((Segment)operation.apply((original = (Segment)this.segments.get(pContexts)) == null ? MemorySegment.create() : original));
        if (original != mapped) {
            return this.newData(mapped.empty() ? this.segments.minus(pContexts) : this.segments.plus(pContexts, (Object)mapped));
        }
        return this;
    }

    public <V> Map<Set<ContextValue<?>>, V> mapSegmentValues(Function<Segment, V> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return PCollections.asMap(this.segments, (k, v) -> k, (k, v) -> mapper.apply((Segment)v));
    }

    public <V> @Nullable V mapSegment(Set<ContextValue<?>> contexts, Function<Segment, V> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        MemorySegment segment = (MemorySegment)this.segments.get(PCollections.asSet(Objects.requireNonNull(contexts, "contexts")));
        if (segment != null) {
            return mapper.apply(segment);
        }
        return null;
    }

    public MemorySegment segment(Set<ContextValue<?>> contexts) {
        MemorySegment res = (MemorySegment)this.segments.get(PCollections.asSet(contexts));
        if (res == null) {
            res = MemorySegment.create();
        }
        return res;
    }

    public ImmutableSubjectData withSegment(Set<ContextValue<?>> contexts, Segment segment) {
        PMap segments = segment.empty() ? this.segments.minus(PCollections.asSet(contexts)) : this.segments.plus(PCollections.asSet(contexts), (Object)MemorySegment.from(segment));
        return segments == this.segments ? this : this.newData(segments);
    }

    public Set<PSet<ContextValue<?>>> activeContexts() {
        return this.segments.keySet();
    }

    public String toString() {
        return "MemorySubjectData{segments=" + this.segments + '}';
    }

    static {
        try {
            MAPPER = ObjectMapper.factory().get(MemorySegment.class);
        }
        catch (SerializationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @ConfigSerializable
    protected static class MemorySegment
    implements Segment {
        @Setting
        private PMap<String, Integer> permissions;
        @Setting
        private PMap<String, String> options;
        @Setting
        private PVector<SubjectRef<?>> parents;
        @Setting(value="permissions-default")
        private @Nullable Integer defaultValue;

        static MemorySegment create() {
            return new MemorySegment(PCollections.map(), PCollections.map(), PCollections.vector(), null);
        }

        static MemorySegment from(Segment other) {
            if (other instanceof MemorySegment) {
                return (MemorySegment)other;
            }
            return new MemorySegment(PCollections.asMap(other.permissions()), PCollections.asMap(other.options()), PCollections.narrow(PCollections.asVector(other.parents())), other.fallbackPermission());
        }

        MemorySegment(PMap<String, Integer> permissions, PMap<String, String> options, PVector<SubjectRef<?>> parents, @Nullable Integer defaultValue) {
            this.permissions = permissions;
            this.options = options;
            this.parents = parents;
            this.defaultValue = defaultValue;
        }

        private MemorySegment() {
        }

        public Map<String, String> options() {
            return this.options;
        }

        public MemorySegment withOption(String key, String value) {
            return new MemorySegment(this.permissions, (PMap<String, String>)this.options.plus((Object)key, (Object)value), this.parents, this.defaultValue);
        }

        public MemorySegment withoutOption(String key) {
            if (!this.options.containsKey((Object)key)) {
                return this;
            }
            return new MemorySegment(this.permissions, (PMap<String, String>)this.options.minus((Object)key), this.parents, this.defaultValue);
        }

        public MemorySegment withOptions(Map<String, String> values) {
            return new MemorySegment(this.permissions, PCollections.asMap(values), this.parents, this.defaultValue);
        }

        public MemorySegment withoutOptions() {
            return new MemorySegment(this.permissions, PCollections.map(), this.parents, this.defaultValue);
        }

        public Map<String, Integer> permissions() {
            return this.permissions;
        }

        public MemorySegment withPermission(String permission, int value) {
            return new MemorySegment((PMap<String, Integer>)(value == 0 ? this.permissions.minus((Object)permission) : this.permissions.plus((Object)permission, (Object)value)), this.options, this.parents, this.defaultValue);
        }

        public MemorySegment withPermissions(Map<String, Integer> values) {
            return new MemorySegment(PCollections.asMap(values), this.options, this.parents, this.defaultValue);
        }

        public MemorySegment withoutPermissions() {
            return new MemorySegment(PCollections.map(), this.options, this.parents, this.defaultValue);
        }

        public List<SubjectRef<?>> parents() {
            return this.parents;
        }

        public <I> MemorySegment plusParent(SubjectRef<I> parent) {
            return new MemorySegment(this.permissions, this.options, this.parents.plus(0, (Object)SubjectRef.mapKeySafe(parent)), this.defaultValue);
        }

        public <I> MemorySegment minusParent(SubjectRef<I> parent) {
            if (this.parents.isEmpty()) {
                return this;
            }
            return new MemorySegment(this.permissions, this.options, this.parents.minus((Object)SubjectRef.mapKeySafe(parent)), this.defaultValue);
        }

        public MemorySegment withParents(List<SubjectRef<?>> parents) {
            return new MemorySegment(this.permissions, this.options, PCollections.asVector(parents), this.defaultValue);
        }

        public MemorySegment withoutParents() {
            return new MemorySegment(this.permissions, this.options, PCollections.vector(), this.defaultValue);
        }

        public int fallbackPermission() {
            return this.defaultValue == null ? 0 : this.defaultValue;
        }

        public Segment withFallbackPermission(int defaultValue) {
            return new MemorySegment(this.permissions, this.options, this.parents, defaultValue);
        }

        public Segment cleared() {
            return new MemorySegment(PCollections.map(), PCollections.map(), PCollections.vector(), null);
        }

        public String toString() {
            return "DataEntry{permissions=" + this.permissions + ", options=" + this.options + ", parents=" + this.parents + ", defaultValue=" + this.defaultValue + '}';
        }

        public boolean empty() {
            return this.permissions.isEmpty() && this.options.isEmpty() && this.parents.isEmpty() && this.defaultValue == null;
        }
    }
}

