/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.impl.util.PCollections;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PMap;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class PMapSerializer
implements TypeSerializer<PMap<?, ?>> {
    public static final TypeToken<PMap<?, ?>> TYPE = new TypeToken<PMap<?, ?>>(){};
    public static final PMapSerializer INSTANCE = new PMapSerializer();

    private PMapSerializer() {
    }

    public PMap<?, ?> deserialize(Type type, ConfigurationNode node) throws SerializationException {
        PMap ret = PCollections.map();
        if (node.isMap()) {
            if (!(type instanceof ParameterizedType)) {
                throw new SerializationException(type, "Raw types are not supported for collections");
            }
            ParameterizedType param = (ParameterizedType)type;
            if (param.getActualTypeArguments().length != 2) {
                throw new SerializationException(type, "Map expected two type arguments!");
            }
            Type key = param.getActualTypeArguments()[0];
            Type value = param.getActualTypeArguments()[1];
            @Nullable TypeSerializer keySerial = node.options().serializers().get(key);
            @Nullable TypeSerializer valueSerial = node.options().serializers().get(value);
            if (keySerial == null) {
                throw new SerializationException(type, "No type serializer available for key type " + key);
            }
            if (valueSerial == null) {
                throw new SerializationException(type, "No type serializer available for value type " + value);
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
            for (Map.Entry ent : node.childrenMap().entrySet()) {
                ret = ret.plus(Objects.requireNonNull(keySerial.deserialize(key, (ConfigurationNode)keyNode.set(ent.getKey())), "key"), Objects.requireNonNull(valueSerial.deserialize(value, (ConfigurationNode)ent.getValue()), "value"));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Type type, @Nullable PMap<?, ?> obj, ConfigurationNode node) throws SerializationException {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        ParameterizedType param = (ParameterizedType)type;
        if (param.getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type key = param.getActualTypeArguments()[0];
        Type value = param.getActualTypeArguments()[1];
        @Nullable TypeSerializer keySerial = node.options().serializers().get(key);
        @Nullable TypeSerializer valueSerial = node.options().serializers().get(value);
        if (keySerial == null) {
            throw new SerializationException(type, "No type serializer available for key type " + key);
        }
        if (valueSerial == null) {
            throw new SerializationException(type, "No type serializer available for value type " + value);
        }
        if (obj == null || obj.isEmpty()) {
            node.set(Collections.emptyMap());
        } else {
            Set<Object> unvisitedKeys;
            if (node.empty()) {
                node.raw(Collections.emptyMap());
                unvisitedKeys = Collections.emptySet();
            } else {
                unvisitedKeys = new HashSet(node.childrenMap().keySet());
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
            for (Map.Entry ent : obj.entrySet()) {
                keySerial.serialize(key, ent.getKey(), (ConfigurationNode)keyNode);
                Object keyObj = Objects.requireNonNull(keyNode.raw(), "Key must not be null!");
                ConfigurationNode child = node.node(new Object[]{keyObj});
                try {
                    valueSerial.serialize(value, ent.getValue(), child);
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)child).path());
                }
                finally {
                    unvisitedKeys.remove(keyObj);
                }
            }
            for (Object unusedChild : unvisitedKeys) {
                node.removeChild(unusedChild);
            }
        }
    }

    public @Nullable PMap<?, ?> emptyValue(Type specificType, ConfigurationOptions options) {
        return PCollections.map();
    }
}

