/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class SubjectRefSerializer
implements TypeSerializer<SubjectRef<?>> {
    public static final TypeToken<SubjectRef<?>> TYPE = new TypeToken<SubjectRef<?>>(){};
    private final DataStoreContext engine;
    private final @Nullable SubjectType<?> defaultType;

    public SubjectRefSerializer(DataStoreContext engine, @Nullable SubjectType<?> defaultType) {
        this.engine = engine;
        this.defaultType = defaultType;
    }

    public SubjectRef<?> deserialize(Type type, ConfigurationNode node) throws SerializationException {
        @Nullable String value = node.getString();
        if (value == null) {
            throw new SerializationException(node, type, "Node value was not a string");
        }
        String[] entries = value.split(":", 2);
        if (entries.length == 1) {
            if (this.defaultType == null) {
                throw new SerializationException(node, type, "No default type was specified but subject '" + value + "' has no specified type!");
            }
            return SubjectRef.subject(this.defaultType, (Object)this.defaultType.parseIdentifier(entries[0]));
        }
        return this.engine.lazySubjectRef(entries[0], entries[1]);
    }

    public void serialize(Type type, @Nullable SubjectRef<?> obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
        } else if (Objects.equals(obj.type(), this.defaultType)) {
            node.set((Object)obj.serializedIdentifier());
        } else {
            node.set((Object)(obj.type().name() + ':' + obj.serializedIdentifier()));
        }
    }
}

