/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.context;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TimeContextParser {
    public static TimeContextParser[] parsersForZone(ZoneId zone) {
        return new TimeContextParser[]{new ByDateTimeFormatter(DateTimeFormatter.ISO_DATE_TIME.withZone(zone)), new ByDateTimeFormatter(DateTimeFormatter.ISO_TIME.withZone(zone)), new ByDateTimeFormatter(DateTimeFormatter.ISO_DATE.withZone(zone)), new ByDateTimeFormatter(DateTimeFormatter.RFC_1123_DATE_TIME.withZone(zone)), new Relative(zone), new ByEpochTime(zone)};
    }

    public @Nullable ZonedDateTime parse(String var1);

    public static final class Relative
    implements TimeContextParser {
        private static final Pattern RELATIVE_TIME_PART = Pattern.compile("^(((?:\\+|-)?)[0-9\\.]*[0-9])(seconds?|minutes?|hours?|days?|weeks?|months?|years?|s|m|h|d|w|y)");
        private final ZoneId zone;

        public Relative(ZoneId zone) {
            this.zone = zone;
        }

        private static ChronoUnit unit(String spec) {
            switch (spec) {
                case "second": 
                case "seconds": 
                case "s": {
                    return ChronoUnit.SECONDS;
                }
                case "minute": 
                case "minutes": 
                case "m": {
                    return ChronoUnit.MINUTES;
                }
                case "hour": 
                case "hours": 
                case "h": {
                    return ChronoUnit.HOURS;
                }
                case "day": 
                case "days": 
                case "d": {
                    return ChronoUnit.DAYS;
                }
                case "week": 
                case "weeks": 
                case "w": {
                    return ChronoUnit.WEEKS;
                }
                case "month": 
                case "months": {
                    return ChronoUnit.MONTHS;
                }
                case "year": 
                case "years": 
                case "y": {
                    return ChronoUnit.YEARS;
                }
            }
            throw new IllegalStateException("Hit datetime opcode which was unspecified");
        }

        @Override
        public @Nullable ZonedDateTime parse(String input) {
            if (input.length() < 3) {
                return null;
            }
            char initial = input.charAt(0);
            if (initial != '+' && initial != '-') {
                return null;
            }
            ZonedDateTime working = ZonedDateTime.now(this.zone);
            Matcher match = RELATIVE_TIME_PART.matcher(input);
            int index = 0;
            boolean positive = true;
            while (match.find(index)) {
                long quantity;
                positive = !"-".equals(match.group(1));
                try {
                    quantity = Long.parseLong(match.group(2));
                }
                catch (NumberFormatException ex) {
                    return null;
                }
                if (!positive) {
                    quantity = -quantity;
                }
                ChronoUnit unit = Relative.unit(match.group(3));
                working = working.plus(quantity, unit);
                index += match.group().length();
            }
            if (index == input.length()) {
                return working;
            }
            return null;
        }
    }

    public static final class ByEpochTime
    implements TimeContextParser {
        private final ZoneId zone;

        public ByEpochTime(ZoneId zone) {
            this.zone = zone;
        }

        @Override
        public @Nullable ZonedDateTime parse(String input) {
            try {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(input)), this.zone);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    public static final class ByDateTimeFormatter
    implements TimeContextParser {
        private final DateTimeFormatter formatter;

        public ByDateTimeFormatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public @Nullable ZonedDateTime parse(String input) {
            try {
                return ZonedDateTime.parse(input, this.formatter);
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
    }
}

