/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.logging.FormattedLogger;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class WrappingFormattedLogger
implements FormattedLogger {
    private final Logger wrapping;
    private @Nullable String prefix;
    private final boolean supportsFormatting;

    public static FormattedLogger of(Logger logger, boolean supportsFormatting) {
        return logger instanceof FormattedLogger ? (FormattedLogger)logger : new WrappingFormattedLogger(logger, supportsFormatting);
    }

    public WrappingFormattedLogger(Logger wrapping, boolean supportsFormatting) {
        this.wrapping = wrapping;
        this.supportsFormatting = supportsFormatting;
    }

    public Locale logLocale() {
        return Locale.getDefault();
    }

    public Locale logLocale(@Nullable Marker marker) {
        return this.logLocale();
    }

    public @Nullable String prefix() {
        return this.prefix;
    }

    public void prefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    public ComponentSerializer<Component, ?, String> serializer() {
        if (this.supportsFormatting) {
            return LegacyComponentSerializer.legacySection();
        }
        return PlainComponentSerializer.plain();
    }

    public String formatText(Component component, @Nullable Marker marker) {
        return (String)this.serializer().serialize(GlobalTranslator.render((Component)component, (Locale)this.logLocale(marker)));
    }

    private String applyPrefix(String input) {
        @Nullable String prefix = this.prefix;
        return prefix == null ? input : prefix + input;
    }

    public String getName() {
        return this.wrapping.getName();
    }

    public boolean isTraceEnabled() {
        return this.wrapping.isTraceEnabled();
    }

    public void trace(String msg) {
        this.wrapping.trace(this.applyPrefix(msg));
    }

    public void trace(String format, Object arg) {
        this.wrapping.trace(this.applyPrefix(format), arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.wrapping.trace(this.applyPrefix(format), arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.wrapping.trace(this.applyPrefix(format), arguments);
    }

    public void trace(String msg, Throwable t) {
        this.wrapping.trace(this.applyPrefix(msg), t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.wrapping.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.wrapping.trace(marker, this.applyPrefix(msg));
    }

    public void trace(Marker marker, String format, Object arg) {
        this.wrapping.trace(marker, this.applyPrefix(format), arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.trace(marker, this.applyPrefix(format), arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.wrapping.trace(marker, this.applyPrefix(format), argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.wrapping.trace(marker, this.applyPrefix(msg), t);
    }

    public boolean isDebugEnabled() {
        return this.wrapping.isDebugEnabled();
    }

    public void debug(String msg) {
        this.wrapping.debug(this.applyPrefix(msg));
    }

    public void debug(String format, Object arg) {
        this.wrapping.debug(this.applyPrefix(format), arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.wrapping.debug(this.applyPrefix(format), arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.wrapping.debug(this.applyPrefix(format), arguments);
    }

    public void debug(String msg, Throwable t) {
        this.wrapping.debug(this.applyPrefix(msg), t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.wrapping.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.wrapping.debug(marker, this.applyPrefix(msg));
    }

    public void debug(Marker marker, String format, Object arg) {
        this.wrapping.debug(marker, this.applyPrefix(format), arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.debug(marker, this.applyPrefix(format), arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.wrapping.debug(marker, this.applyPrefix(format), arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.wrapping.debug(marker, this.applyPrefix(msg), t);
    }

    public boolean isInfoEnabled() {
        return this.wrapping.isInfoEnabled();
    }

    public void info(String msg) {
        this.wrapping.info(this.applyPrefix(msg));
    }

    public void info(String format, Object arg) {
        this.wrapping.info(this.applyPrefix(format), arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.wrapping.info(this.applyPrefix(format), arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.wrapping.info(this.applyPrefix(format), arguments);
    }

    public void info(String msg, Throwable t) {
        this.wrapping.info(this.applyPrefix(msg), t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.wrapping.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.wrapping.info(marker, this.applyPrefix(msg));
    }

    public void info(Marker marker, String format, Object arg) {
        this.wrapping.info(marker, this.applyPrefix(format), arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.info(marker, this.applyPrefix(format), arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.wrapping.info(marker, this.applyPrefix(format), arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.wrapping.info(marker, this.applyPrefix(msg), t);
    }

    public boolean isWarnEnabled() {
        return this.wrapping.isWarnEnabled();
    }

    public void warn(String msg) {
        this.wrapping.warn(this.applyPrefix(msg));
    }

    public void warn(String format, Object arg) {
        this.wrapping.warn(this.applyPrefix(format), arg);
    }

    public void warn(String format, Object ... arguments) {
        this.wrapping.warn(this.applyPrefix(format), arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.wrapping.warn(this.applyPrefix(format), arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.wrapping.warn(this.applyPrefix(msg), t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.wrapping.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.wrapping.warn(marker, this.applyPrefix(msg));
    }

    public void warn(Marker marker, String format, Object arg) {
        this.wrapping.warn(marker, this.applyPrefix(format), arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.warn(marker, this.applyPrefix(format), arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.wrapping.warn(marker, this.applyPrefix(format), arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.wrapping.warn(marker, this.applyPrefix(msg), t);
    }

    public boolean isErrorEnabled() {
        return this.wrapping.isErrorEnabled();
    }

    public void error(String msg) {
        this.wrapping.error(this.applyPrefix(msg));
    }

    public void error(String format, Object arg) {
        this.wrapping.error(this.applyPrefix(format), arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.wrapping.error(this.applyPrefix(format), arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.wrapping.error(this.applyPrefix(format), arguments);
    }

    public void error(String msg, Throwable t) {
        this.wrapping.error(this.applyPrefix(msg), t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.wrapping.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.wrapping.error(marker, this.applyPrefix(msg));
    }

    public void error(Marker marker, String format, Object arg) {
        this.wrapping.error(marker, this.applyPrefix(format), arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.error(marker, this.applyPrefix(format), arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.wrapping.error(marker, this.applyPrefix(format), arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.wrapping.error(marker, this.applyPrefix(msg), t);
    }
}

