/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.rank;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.rank.Messages;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.pcollections.PVector;

public abstract class AbstractRankLadder
implements RankLadder {
    private final String name;

    protected AbstractRankLadder(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public final ImmutableSubjectData promote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        return input.withSegment(contexts, seg -> {
            List originalParents = seg.parents();
            if (originalParents.isEmpty()) {
                return seg.plusParent((SubjectRef)this.ranks().get(0));
            }
            ArrayList parents = new ArrayList(originalParents);
            boolean found = false;
            ListIterator<SubjectRef> it = parents.listIterator();
            while (it.hasNext()) {
                SubjectRef parent = (SubjectRef)it.next();
                int index = this.ranks().indexOf((Object)parent);
                if (index <= -1) continue;
                if (index == this.ranks().size() - 1) {
                    return seg;
                }
                it.set((SubjectRef)this.ranks().get(index + 1));
                found = true;
            }
            if (found) {
                return seg.withParents(parents);
            }
            return seg.plusParent((SubjectRef)this.ranks().get(0));
        });
    }

    public final ImmutableSubjectData demote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        return input.withSegment(contexts, seg -> {
            List originalParents = seg.parents();
            if (originalParents.isEmpty()) {
                return seg;
            }
            ArrayList parents = new ArrayList(originalParents);
            boolean found = false;
            ListIterator<SubjectRef> it = parents.listIterator();
            while (it.hasNext()) {
                SubjectRef parent = (SubjectRef)it.next();
                int index = this.ranks().indexOf((Object)parent);
                if (index <= -1) continue;
                if (index == 0) {
                    it.remove();
                } else {
                    it.set((SubjectRef)this.ranks().get(index - 1));
                }
                found = true;
            }
            if (found) {
                return seg.withParents(parents);
            }
            return seg;
        });
    }

    public final boolean isOnLadder(Set<ContextValue<?>> contexts, ImmutableSubjectData subject) {
        if (this.ranks().isEmpty()) {
            return false;
        }
        for (SubjectRef par : subject.segment(contexts).parents()) {
            if (!this.ranks().contains((Object)par)) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(SubjectRef<?> subject) {
        return this.ranks().indexOf(subject);
    }

    public final RankLadder with(SubjectRef<?> subject) {
        int indexOf = this.ranks().indexOf(subject);
        if (indexOf != -1) {
            return this.newWithRanks(this.ranks().minus(indexOf).plus((Object)SubjectRef.mapKeySafe(subject)));
        }
        return this.newWithRanks(this.ranks().plus((Object)SubjectRef.mapKeySafe(subject)));
    }

    public final RankLadder with(SubjectRef<?> subject, int index) {
        if (index > this.ranks().size() || index < 0) {
            return this;
        }
        PVector entries = this.ranks();
        int indexOf = entries.indexOf(subject);
        entries = entries.plus(index, subject);
        if (indexOf != -1) {
            if (indexOf >= index) {
                ++indexOf;
            }
            entries = entries.minus(indexOf);
        }
        return this.newWithRanks(entries);
    }

    public final RankLadder without(SubjectRef<?> subject) {
        PVector out = this.ranks().minus(subject);
        return this.ranks() == out ? this : this.newWithRanks(out);
    }

    public abstract PVector<SubjectRef<?>> ranks();

    protected abstract RankLadder newWithRanks(PVector<SubjectRef<?>> var1);

    public final Component asComponent() {
        return Component.text(build -> ((TextComponent.Builder)((TextComponent.Builder)build.content(this.name()).decoration(TextDecoration.BOLD, true)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Messages.FORMATTER_BUTTON_INFO_PROMPT.tr(new Object[0])))).clickEvent(ClickEvent.runCommand((String)("/pex rank " + this.name()))));
    }
}

