/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class CacheListenerHolder<Key, CacheType> {
    private final ConcurrentMap<Key, Set<Consumer<CacheType>>> listeners = new ConcurrentHashMap<Key, Set<Consumer<CacheType>>>();

    private Set<Consumer<CacheType>> getListeners(Key key) {
        Objects.requireNonNull(key, "key");
        return this.listeners.computeIfAbsent(key, k -> Collections.newSetFromMap(Caffeine.newBuilder().weakKeys().build().asMap()));
    }

    public void call(Key key, CacheType newData) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(newData, "newData");
        for (Consumer<CacheType> listener : this.getListeners(key)) {
            listener.accept(newData);
        }
    }

    public void addListener(Key key, Consumer<CacheType> listener) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(listener, "listener");
        this.getListeners(key).add(listener);
    }

    public void removeListener(Key key, Consumer<CacheType> listener) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(listener, "listener");
        this.getListeners(key).remove(listener);
    }

    public Iterable<Key> getAllKeys() {
        return Collections.unmodifiableSet(this.listeners.keySet());
    }

    public void removeAll(Key key) {
        this.listeners.remove(key);
    }
}

