package ca.stellardrift.permissionsex.sponge;

import ca.stellardrift.permissionsex.util.TranslatableProvider;

final class Messages {
    private static final String BUNDLE_NAME = "ca.stellardrift.permissionsex.sponge.messages";

    public static final TranslatableProvider PLUGIN_DATA_SOURCE_ERROR = new TranslatableProvider(BUNDLE_NAME, "plugin.data-source.error");
    public static final TranslatableProvider FORMATTER_ERROR_SUBJECT_NAME = new TranslatableProvider(BUNDLE_NAME, "formatter.error.subject-name");
    public static final TranslatableProvider FORMATTER_BUTTON_INFO_PROMPT = new TranslatableProvider(BUNDLE_NAME, "formatter.button.info-prompt");
    public static final TranslatableProvider PLUGIN_INIT_ERROR_GENERAL = new TranslatableProvider(BUNDLE_NAME, "plugin.init.error.general");
    public static final TranslatableProvider COMMANDS_FAKE_OP_ARG_USER = new TranslatableProvider(BUNDLE_NAME, "commands.fake-op.arg.user");
    public static final TranslatableProvider PLUGIN_INIT_ERROR_OTHER_PROVIDER_INSTALLED = new TranslatableProvider(BUNDLE_NAME, "plugin.init.error.other-provider-installed");
    public static final TranslatableProvider COMMANDS_FAKE_OP_DESCRIPTION = new TranslatableProvider(BUNDLE_NAME, "commands.fake-op.description");
    public static final TranslatableProvider COMMANDS_FAKE_OP_ERROR = new TranslatableProvider(BUNDLE_NAME, "commands.fake-op.error");
    public static final TranslatableProvider PLUGIN_SHUTDOWN_BEGIN = new TranslatableProvider(BUNDLE_NAME, "plugin.shutdown.begin");
    public static final TranslatableProvider MIGRATION_BUKKIT_BEGIN = new TranslatableProvider(BUNDLE_NAME, "migration.bukkit.begin");
    public static final TranslatableProvider PLUGIN_INIT_BEGIN = new TranslatableProvider(BUNDLE_NAME, "plugin.init.begin");
    public static final TranslatableProvider EVENT_CLIENT_AUTH_ERROR = new TranslatableProvider(BUNDLE_NAME, "event.client-auth.error");
    public static final TranslatableProvider MIGRATION_LEGACY_SPONGE_SUCCESS = new TranslatableProvider(BUNDLE_NAME, "migration.legacy-sponge.success");

    private Messages() {
    }

    static {
        TranslatableProvider.registerAllTranslations(
            BUNDLE_NAME,
            TranslatableProvider.knownLocales(Messages.class, BUNDLE_NAME),
            Messages.class.getClassLoader()
        );
    }
}
