package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.util.TranslatableProvider;

final class Messages {
    private static final String BUNDLE_NAME = "ca.stellardrift.permissionsex.datastore.sql.messages";

    public static final TranslatableProvider SCHEMA_UPDATE_SUCCESS = new TranslatableProvider(BUNDLE_NAME, "schema-update.success");
    public static final TranslatableProvider DB_CONNECTION_ERROR = new TranslatableProvider(BUNDLE_NAME, "db.connection-error");
    public static final TranslatableProvider ERROR_LOADING = new TranslatableProvider(BUNDLE_NAME, "error.loading");
    public static final TranslatableProvider ERROR_INITIALIZE_TABLES = new TranslatableProvider(BUNDLE_NAME, "error.initialize-tables");
    public static final TranslatableProvider DB_IMPL_NOT_SUPPORTED = new TranslatableProvider(BUNDLE_NAME, "db.impl-not-supported");

    private Messages() {
    }

    static {
        TranslatableProvider.registerAllTranslations(
            BUNDLE_NAME,
            TranslatableProvider.knownLocales(Messages.class, BUNDLE_NAME),
            Messages.class.getClassLoader()
        );
    }
}
