/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.SqlRankLadder;
import ca.stellardrift.permissionsex.datastore.sql.SqlSegment;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectRef;
import ca.stellardrift.permissionsex.datastore.sql.dao.LegacyMigration;
import ca.stellardrift.permissionsex.datastore.sql.dao.SchemaMigration;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.legacy.LegacyConversions;
import ca.stellardrift.permissionsex.rank.RankLadder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PVector;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public class SchemaMigrations {
    public static final int VERSION_LATEST = 3;

    public static List<SchemaMigration> getMigrations() {
        ArrayList<SchemaMigration> migrations = new ArrayList<SchemaMigration>();
        migrations.add(0, SchemaMigrations.initialToZero());
        migrations.add(1, SchemaMigrations.zeroToOne());
        migrations.add(2, SchemaMigrations.oneToTwo());
        migrations.add(3, SchemaMigrations.twoToThree());
        return migrations;
    }

    public static SchemaMigration twoToThree() {
        return dao -> {
            dao.legacy().renameTable(dao, "permissions", "permissions_old");
            dao.legacy().renameTable(dao, "permissions_entity", "permissions_entity_old");
            dao.legacy().renameTable(dao, "permissions_inheritance", "permissions_inheritance_old");
            dao.initializeTables();
            try (PreparedStatement stmt = dao.prepareStatement("SELECT id, child, parent FROM {}permissions_inheritance_old WHERE type=2 ORDER BY child, parent, id ASC");){
                ResultSet rs = stmt.executeQuery();
                try (PreparedStatement insert = dao.prepareStatement(dao.getInsertContextInheritanceQuery());){
                    insert.setString(1, "world");
                    insert.setString(3, "world");
                    while (rs.next()) {
                        insert.setString(2, rs.getString(2));
                        insert.setString(4, rs.getString(3));
                        insert.addBatch();
                    }
                    insert.executeBatch();
                }
            }
            HashMap<String, List> defaultSubjects = new HashMap<String, List>();
            HashMap<String, List> tempRankLadders = new HashMap<String, List>();
            try (PreparedStatement select = dao.prepareStatement("SELECT type, name FROM {}permissions_entity_old");){
                ResultSet rs = select.executeQuery();
                while (rs.next()) {
                    SqlSubjectRef<?> ref = dao.getOrCreateSubjectRef(LegacyMigration.Type.values()[rs.getInt(1)].name().toLowerCase(), rs.getString(2));
                    SqlSegment currentSeg = null;
                    String currentWorld = null;
                    HashMap<String, SqlSegment> worldSegments = new HashMap<String, SqlSegment>();
                    try (PreparedStatement selectPermissionsOptions = dao.prepareStatement("SELECT id, permission, world, value FROM {}permissions_old WHERE type=? AND name=? ORDER BY world, id DESC");){
                        selectPermissionsOptions.setInt(1, rs.getInt(1));
                        selectPermissionsOptions.setString(2, rs.getString(2));
                        ResultSet resultSet = selectPermissionsOptions.executeQuery();
                        HashMap<String, Integer> newPerms = new HashMap<String, Integer>();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String rank = null;
                        String rankLadder = null;
                        int defaultVal = 0;
                        while (resultSet.next()) {
                            @Nullable String worldChecked = resultSet.getString(3);
                            if (worldChecked != null && worldChecked.isEmpty()) {
                                worldChecked = null;
                            }
                            if (currentSeg == null || !Objects.equals(worldChecked, currentWorld)) {
                                if (currentSeg != null) {
                                    if (!hashMap.isEmpty()) {
                                        dao.setOptions(currentSeg, hashMap);
                                        hashMap.clear();
                                    }
                                    if (!newPerms.isEmpty()) {
                                        dao.setPermissions(currentSeg, newPerms);
                                        newPerms.clear();
                                    }
                                    if (defaultVal != 0) {
                                        dao.setDefaultValue(currentSeg, defaultVal);
                                        defaultVal = 0;
                                    }
                                }
                                currentSeg = SqlSegment.unallocated((currentWorld = worldChecked) == null ? PCollections.set() : PCollections.set((Object)new ContextValue("world", currentWorld)));
                                dao.allocateSegment(ref, currentSeg);
                                worldSegments.put(currentWorld, currentSeg);
                            }
                            String key = resultSet.getString(2);
                            String value = resultSet.getString(4);
                            if (value == null || value.isEmpty()) {
                                int val;
                                int n = val = key.startsWith("-") ? -1 : 1;
                                if (val == -1) {
                                    key = key.substring(1);
                                }
                                if (key.equals("*")) {
                                    defaultVal = val;
                                    continue;
                                }
                                key = LegacyConversions.convertLegacyPermission((String)key);
                                newPerms.put(key, val);
                                continue;
                            }
                            if (currentWorld == null) {
                                boolean rankLadderEq;
                                boolean rankEq = key.equals("rank");
                                boolean bl = rankLadderEq = !rankEq && key.equals("rank-ladder");
                                if (rankEq || rankLadderEq) {
                                    if (rankEq) {
                                        rank = value;
                                    } else {
                                        rankLadder = value;
                                    }
                                    if (rank == null || rankLadder == null) continue;
                                    List ladder = tempRankLadders.computeIfAbsent(rankLadder, ign -> new ArrayList());
                                    try {
                                        ladder.add(UnmodifiableCollections.immutableMapEntry(ref, (Object)Integer.parseInt(rank)));
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        // empty catch block
                                    }
                                    rankLadder = null;
                                    rank = null;
                                    continue;
                                }
                            }
                            if (key.equals("default") && value.equalsIgnoreCase("true")) {
                                defaultSubjects.computeIfAbsent(currentWorld, ign -> new ArrayList()).add(ref);
                                continue;
                            }
                            hashMap.put(key, value);
                        }
                        if (currentSeg != null) {
                            if (!hashMap.isEmpty()) {
                                dao.setOptions(currentSeg, hashMap);
                            }
                            if (!newPerms.isEmpty()) {
                                dao.setPermissions(currentSeg, newPerms);
                            }
                            if (defaultVal != 0) {
                                dao.setDefaultValue(currentSeg, defaultVal);
                            }
                            if (rank != null) {
                                List ladder = tempRankLadders.computeIfAbsent("default", ign -> new ArrayList());
                                try {
                                    ladder.add(UnmodifiableCollections.immutableMapEntry(ref, (Object)Integer.parseInt(rank)));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    for (Map.Entry entry : tempRankLadders.entrySet()) {
                        PVector ladder = (PVector)((List)entry.getValue()).stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).map(Map.Entry::getKey).collect(PCollections.toPVector());
                        dao.setRankLadder((String)entry.getKey(), (RankLadder)new SqlRankLadder((String)entry.getKey(), ladder));
                    }
                    if (!defaultSubjects.isEmpty()) {
                        SqlSubjectRef<?> defaultSubj = dao.getOrCreateSubjectRef(dao.getDataStore().ctx().engine().fallbacks().type().name(), "user");
                        ArrayList<SqlSegment> arrayList = new ArrayList<SqlSegment>(dao.getSegments(defaultSubj));
                        for (Map.Entry entry : defaultSubjects.entrySet()) {
                            SqlSegment seg = null;
                            if (!arrayList.isEmpty()) {
                                for (SqlSegment segment : arrayList) {
                                    ContextValue ctx;
                                    if (entry.getKey() == null && segment.contexts().isEmpty()) {
                                        seg = segment;
                                        break;
                                    }
                                    if (segment.contexts().size() != 1 || !(ctx = (ContextValue)segment.contexts().iterator().next()).key().equals("world") || !ctx.rawValue().equals(entry.getKey())) continue;
                                    seg = segment;
                                    break;
                                }
                            }
                            if (seg == null) {
                                seg = SqlSegment.unallocated(entry.getKey() == null ? PCollections.set() : PCollections.set((Object)new ContextValue("world", (String)entry.getKey())));
                                dao.allocateSegment(defaultSubj, seg);
                                arrayList.add(seg);
                            }
                            dao.setParents(seg, (Iterable)entry.getValue());
                        }
                    }
                    PreparedStatement selectInheritance = dao.prepareStatement(dao.legacy().getSelectParentsQuery());
                    try {
                        selectInheritance.setString(1, rs.getString(2));
                        selectInheritance.setInt(2, rs.getInt(1));
                        ResultSet resultSet = selectInheritance.executeQuery();
                        ArrayDeque newInheritance = new ArrayDeque();
                        while (resultSet.next()) {
                            if (currentSeg == null || !Objects.equals(resultSet.getString(3), currentWorld)) {
                                if (currentSeg != null && !newInheritance.isEmpty()) {
                                    dao.setParents(currentSeg, newInheritance);
                                    newInheritance.clear();
                                }
                                if ((currentSeg = (SqlSegment)worldSegments.get(currentWorld = resultSet.getString(3))) == null) {
                                    currentSeg = SqlSegment.unallocated(currentWorld == null ? PCollections.set() : PCollections.set((Object)new ContextValue("world", currentWorld)));
                                    dao.allocateSegment(ref, currentSeg);
                                    worldSegments.put(currentWorld, currentSeg);
                                }
                            }
                            newInheritance.add(dao.getOrCreateSubjectRef("group", resultSet.getString(2)));
                        }
                        if (currentSeg == null || newInheritance.isEmpty()) continue;
                        dao.setParents(currentSeg, newInheritance);
                        newInheritance.clear();
                    }
                    finally {
                        if (selectInheritance == null) continue;
                        selectInheritance.close();
                    }
                }
            }
            dao.deleteTable("permissions_old");
            dao.deleteTable("permissions_entity_old");
            dao.deleteTable("permissions_inheritance_old");
        };
    }

    public static SchemaMigration oneToTwo() {
        return dao -> dao.legacy().prepareStatement(dao, "ALTER TABLE `{permissions}` DROP KEY `unique`, MODIFY COLUMN `permission` TEXT NOT NULL").execute();
    }

    public static SchemaMigration zeroToOne() {
        return dao -> {
            PreparedStatement updateStmt = dao.prepareStatement(dao.legacy().getInsertOptionQuery());
            ResultSet res = dao.legacy().prepareStatement(dao, "SELECT `name`, `type` FROM `{permissions_entity}` WHERE `default`='1'").executeQuery();
            while (res.next()) {
                updateStmt.setString(1, res.getString(1));
                updateStmt.setInt(2, res.getInt(2));
                updateStmt.setString(3, "default");
                updateStmt.setString(4, "");
                updateStmt.setString(5, "true");
                updateStmt.addBatch();
            }
            updateStmt.executeBatch();
            dao.prepareStatement("ALTER TABLE `{permissions_entity}` DROP COLUMN `default`").execute();
        };
    }

    public static SchemaMigration initialToZero() {
        return dao -> {
            PreparedStatement updateStmt = dao.legacy().prepareStatement(dao, dao.legacy().getInsertOptionQuery());
            ResultSet res = dao.prepareStatement("SELECT `name`, `type`, `prefix`, `suffix` FROM `{permissions_entity}` WHERE LENGTH(`prefix`)>0 OR LENGTH(`suffix`)>0").executeQuery();
            while (res.next()) {
                String suffix;
                String prefix = res.getString("prefix");
                if (!prefix.isEmpty() && !prefix.equals("null")) {
                    updateStmt.setString(1, res.getString(1));
                    updateStmt.setInt(2, res.getInt(2));
                    updateStmt.setString(3, "prefix");
                    updateStmt.setString(4, "");
                    updateStmt.setString(5, prefix);
                    updateStmt.addBatch();
                }
                if ((suffix = res.getString("suffix")).isEmpty() || suffix.equals("null")) continue;
                updateStmt.setString(1, res.getString(1));
                updateStmt.setInt(2, res.getInt(2));
                updateStmt.setString(3, "suffix");
                updateStmt.setString(4, "");
                updateStmt.setString(5, suffix);
                updateStmt.addBatch();
            }
            updateStmt.executeBatch();
            dao.prepareStatement("ALTER TABLE `{permissions_entity}` DROP KEY `name`").execute();
            dao.prepareStatement("ALTER TABLE `{permissions_entity}` DROP COLUMN `prefix`, DROP COLUMN `suffix`").execute();
            dao.prepareStatement("ALTER TABLE `{permissions_entity}` ADD CONSTRAINT UNIQUE KEY `name` (`name`, `type`)").execute();
            dao.prepareStatement("ALTER TABLE `{permissions}` DROP KEY `unique`").execute();
            dao.prepareStatement("ALTER TABLE `{permissions}` ADD CONSTRAINT UNIQUE `unique` (`name`,`permission`,`world`,`type`)").execute();
        };
    }
}

