/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.CheckedBiConsumer;
import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PMap;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public class SqlContextInheritance
implements ContextInheritance {
    private final PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance;
    private final AtomicReference<PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>> updatesToPerform = new AtomicReference();

    SqlContextInheritance(PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance) {
        this(inheritance, (PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>)TreePVector.empty());
    }

    SqlContextInheritance(PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance, PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>> updates) {
        this.inheritance = inheritance;
        this.updatesToPerform.set(updates);
    }

    public PVector<ContextValue<?>> parents(ContextValue<?> context) {
        PVector ret = (PVector)this.inheritance.get(context);
        return ret == null ? PCollections.vector() : ret;
    }

    public SqlContextInheritance parents(ContextValue<?> context, @Nullable List<ContextValue<?>> parents) {
        if (parents == null) {
            return new SqlContextInheritance(this.inheritance.minus(context), (PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>)this.updatesToPerform.get().plus((dao, inherit) -> dao.setContextInheritance(context, null)));
        }
        PVector pParent = PCollections.asVector(parents);
        return new SqlContextInheritance(this.inheritance.plus(context, (Object)pParent), (PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>)this.updatesToPerform.get().plus((dao, inherit) -> {
            PVector<ContextValue<?>> newParents = inherit.parents(context);
            if (!newParents.isEmpty()) {
                dao.setContextInheritance(context, newParents);
            }
        }));
    }

    public Map<ContextValue<?>, List<ContextValue<?>>> allParents() {
        return PCollections.narrow(this.inheritance);
    }

    void doUpdate(SqlDao dao) throws SQLException {
        List updates = (List)this.updatesToPerform.getAndSet((PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>)TreePVector.empty());
        for (CheckedBiConsumer action : updates) {
            action.accept(dao, this);
        }
    }
}

