/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql.dao;

import ca.stellardrift.permissionsex.impl.util.PCollections;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.pcollections.PSet;
import org.pcollections.PStack;
import org.pcollections.PVector;

final class PCollectionsCollectorFactory
implements CollectorFactory {
    static final PCollectionsCollectorFactory INSTANCE = new PCollectionsCollectorFactory();
    private final IdentityHashMap<Class<?>, Collector<?, ?, ?>> collectors = new IdentityHashMap();

    private PCollectionsCollectorFactory() {
        this.collectors.put(PSet.class, PCollections.toPSet());
        this.collectors.put(PVector.class, PCollections.toPVector());
        this.collectors.put(PStack.class, PCollections.toPStack());
    }

    public boolean accepts(Type containerType) {
        Class erased = GenericTypeReflector.erase((Type)containerType);
        return this.collectors.containsKey(erased);
    }

    public Optional<Type> elementType(Type containerType) {
        if (!(containerType instanceof ParameterizedType)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((ParameterizedType)containerType).getActualTypeArguments()[0]);
    }

    public Collector<?, ?, ?> build(Type containerType) {
        Collector<?, ?, ?> collector = this.collectors.get(GenericTypeReflector.erase((Type)containerType));
        if (collector == null) {
            throw new IllegalArgumentException("Does not accept " + containerType);
        }
        return collector;
    }
}

