/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.ghrelease;

import ca.stellardrift.ghrelease.GithubReleaserExtension;
import ca.stellardrift.ghrelease.ReleaseJobParameters;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

class GitHubReleaserExtensionImpl
implements GithubReleaserExtension {
    private final Property<String> enterpriseUrl;
    private final Property<String> apiToken;
    private final Property<String> releaseTitle;
    private final Property<String> releaseBody;
    private final Property<String> repository;
    private final Property<String> tagName;
    private final Property<String> sourceBranch;
    private final Property<Boolean> draft;
    private final Property<Boolean> prerelease;
    private final Property<String> discussionCategoryName;
    private final Property<Boolean> generateReleaseNotes;
    private final Property<ReleaseJobParameters.LatestState> makeLatest;
    private final ConfigurableFileCollection sourceArtifacts;

    @Inject
    public GitHubReleaserExtensionImpl(ObjectFactory objects, ProviderFactory providers) {
        this.enterpriseUrl = objects.property(String.class);
        this.apiToken = objects.property(String.class).convention(providers.environmentVariable("GITHUB_TOKEN"));
        this.releaseTitle = objects.property(String.class);
        this.releaseBody = objects.property(String.class).convention((Object)"");
        this.repository = objects.property(String.class);
        this.tagName = objects.property(String.class);
        this.sourceBranch = objects.property(String.class);
        this.draft = objects.property(Boolean.class).convention((Object)false);
        this.prerelease = objects.property(Boolean.class).convention((Object)false);
        this.discussionCategoryName = objects.property(String.class);
        this.generateReleaseNotes = objects.property(Boolean.class).convention((Object)false);
        this.makeLatest = objects.property(ReleaseJobParameters.LatestState.class).convention((Object)ReleaseJobParameters.LatestState.TRUE);
        this.sourceArtifacts = objects.fileCollection();
    }

    @Override
    @NotNull
    public Property<String> getEnterpriseUrl() {
        return this.enterpriseUrl;
    }

    @Override
    @NotNull
    public Property<String> getApiToken() {
        return this.apiToken;
    }

    @Override
    @NotNull
    public Property<String> getReleaseName() {
        return this.releaseTitle;
    }

    @Override
    @NotNull
    public Property<String> getReleaseBody() {
        return this.releaseBody;
    }

    @Override
    @NotNull
    public Property<String> getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public Property<String> getTagName() {
        return this.tagName;
    }

    @Override
    @NotNull
    public Property<String> getSourceBranch() {
        return this.sourceBranch;
    }

    @Override
    @NotNull
    public Property<Boolean> getDraft() {
        return this.draft;
    }

    @Override
    @NotNull
    public Property<Boolean> getPrerelease() {
        return this.prerelease;
    }

    @Override
    @NotNull
    public Property<String> getDiscussionCategoryName() {
        return this.discussionCategoryName;
    }

    @Override
    @NotNull
    public Property<Boolean> getGenerateReleaseNotes() {
        return this.generateReleaseNotes;
    }

    @Override
    @NotNull
    public Property<ReleaseJobParameters.LatestState> getMakeLatest() {
        return this.makeLatest;
    }

    @Override
    @NotNull
    public ConfigurableFileCollection getArtifacts() {
        return this.sourceArtifacts;
    }
}

