/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.extra.GitWorkarounds;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharSequenceNodeFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitAttributesLineEndings {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitAttributesLineEndings.class);

    private GitAttributesLineEndings() {
    }

    public static LineEnding.Policy createFastAllSame(File projectDir, Supplier<Iterable<File>> toFormat) {
        return new LazyAllTheSame(projectDir, toFormat);
    }

    public static LineEnding.Policy create(File projectDir, Supplier<Iterable<File>> toFormat) {
        return new RelocatablePolicy(projectDir, toFormat);
    }

    private static List<AttributesRule> parseRules(@Nullable File file) {
        if (file != null && file.exists() && file.isFile()) {
            List list;
            FileInputStream stream = new FileInputStream(file);
            try {
                AttributesNode parsed = new AttributesNode();
                parsed.parse((InputStream)stream);
                list = parsed.getRules();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Problem parsing {}", (Object)file.getAbsolutePath(), (Object)e);
                }
            }
            ((InputStream)stream).close();
            return list;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String findAttributeInRules(String subpath, boolean isFolder, String key, List<AttributesRule> rules) {
        String value = null;
        for (AttributesRule rule : rules) {
            if (!rule.isMatch(subpath, isFolder)) continue;
            for (Attribute attribute : rule.getAttributes()) {
                if (!attribute.getKey().equals(key)) continue;
                value = attribute.getValue();
            }
        }
        return value;
    }

    static class AttributesCache {
        final Map<File, List<AttributesRule>> rulesAtPath = new HashMap<File, List<AttributesRule>>();

        AttributesCache() {
        }

        @Nullable
        public String valueFor(File file, String key) {
            StringBuilder pathBuilder = new StringBuilder(file.getAbsolutePath().length());
            boolean isDirectory = file.isDirectory();
            pathBuilder.append(file.getName());
            for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                String path = pathBuilder.toString();
                String value = GitAttributesLineEndings.findAttributeInRules(path, isDirectory, key, this.getRulesForFolder(parent));
                if (value != null) {
                    return value;
                }
                pathBuilder.insert(0, parent.getName() + "/");
            }
            return null;
        }

        private List<AttributesRule> getRulesForFolder(File folder) {
            return this.rulesAtPath.computeIfAbsent(folder, f -> GitAttributesLineEndings.parseRules(new File((File)f, ".gitattributes")));
        }
    }

    static class Runtime {
        final List<AttributesRule> infoRules;
        @Nullable
        final File workTree;
        final AttributesCache cache = new AttributesCache();
        final List<AttributesRule> globalRules;
        final String defaultEnding;
        private static final String KEY_EOL = "eol";
        private static final boolean IS_FOLDER = false;

        private Runtime(List<AttributesRule> infoRules, @Nullable File workTree, Config config, List<AttributesRule> globalRules) {
            this.infoRules = Objects.requireNonNull(infoRules);
            this.workTree = workTree;
            this.defaultEnding = this.findDefaultLineEnding(config).str();
            this.globalRules = Objects.requireNonNull(globalRules);
        }

        public String getEndingFor(File file) {
            String localResult;
            if (this.workTree != null && !this.infoRules.isEmpty()) {
                String subpath;
                String infoResult;
                String rootPath = this.workTree.getAbsolutePath();
                String path = file.getAbsolutePath();
                if (path.startsWith(rootPath) && (infoResult = GitAttributesLineEndings.findAttributeInRules(subpath = path.substring(rootPath.length() + 1), false, KEY_EOL, this.infoRules)) != null) {
                    return Runtime.convertEolToLineEnding(infoResult, file);
                }
            }
            if ((localResult = this.cache.valueFor(file, KEY_EOL)) != null) {
                return Runtime.convertEolToLineEnding(localResult, file);
            }
            String globalResult = GitAttributesLineEndings.findAttributeInRules(file.getAbsolutePath(), false, KEY_EOL, this.globalRules);
            if (globalResult != null) {
                return Runtime.convertEolToLineEnding(globalResult, file);
            }
            return this.defaultEnding;
        }

        private static String convertEolToLineEnding(String eol, File file) {
            switch (eol.toLowerCase(Locale.ROOT)) {
                case "lf": {
                    return LineEnding.UNIX.str();
                }
                case "crlf": {
                    return LineEnding.WINDOWS.str();
                }
            }
            LOGGER.warn(".gitattributes file has unspecified eol value: {} for {}, defaulting to platform native", (Object)eol, (Object)file);
            return LineEnding.PLATFORM_NATIVE.str();
        }

        private LineEnding findDefaultLineEnding(Config config) {
            CoreConfig.AutoCRLF autoCRLF = (CoreConfig.AutoCRLF)config.getEnum("core", null, "autocrlf", (Enum)CoreConfig.AutoCRLF.FALSE);
            if (autoCRLF == CoreConfig.AutoCRLF.TRUE) {
                return LineEnding.WINDOWS;
            }
            if (autoCRLF == CoreConfig.AutoCRLF.INPUT) {
                return LineEnding.UNIX;
            }
            if (autoCRLF == CoreConfig.AutoCRLF.FALSE) {
                CoreConfig.EOL eol = (CoreConfig.EOL)config.getEnum("core", null, KEY_EOL, (Enum)CoreConfig.EOL.NATIVE);
                return Runtime.fromEol(eol);
            }
            throw new IllegalStateException("Unexpected value for autoCRLF " + String.valueOf(autoCRLF));
        }

        private static LineEnding fromEol(CoreConfig.EOL eol) {
            switch (eol) {
                case CRLF: {
                    return LineEnding.WINDOWS;
                }
                case LF: {
                    return LineEnding.UNIX;
                }
                case NATIVE: {
                    return LineEnding.PLATFORM_NATIVE;
                }
            }
            throw new IllegalArgumentException("Unknown eol " + String.valueOf(eol));
        }
    }

    static class RuntimeInit {
        final FileBasedConfig systemConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
        final FileBasedConfig userConfig;
        final Config repoConfig;
        @Nullable
        final File globalAttributesFile;
        @Nullable
        final File repoAttributesFile;
        @Nullable
        final File workTree;

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
        RuntimeInit(File projectDir) {
            Errors.log().run(() -> ((FileBasedConfig)this.systemConfig).load());
            this.userConfig = SystemReader.getInstance().openUserConfig((Config)this.systemConfig, FS.DETECTED);
            Errors.log().run(() -> ((FileBasedConfig)this.userConfig).load());
            String globalAttributesPath = ((CoreConfig)this.userConfig.get(CoreConfig.KEY)).getAttributesFile();
            if (globalAttributesPath != null) {
                FS fs = FS.detect();
                this.globalAttributesFile = globalAttributesPath.startsWith("~/") ? fs.resolve(fs.userHome(), globalAttributesPath.substring(2)) : fs.resolve(null, globalAttributesPath);
            } else {
                this.globalAttributesFile = null;
            }
            GitWorkarounds.RepositorySpecificResolver repositoryResolver = GitWorkarounds.fileRepositoryResolverForProject(projectDir, (Config)this.userConfig);
            if (repositoryResolver.getGitDir() != null) {
                this.workTree = repositoryResolver.getWorkTree();
                this.repoConfig = repositoryResolver.getRepositoryConfig();
                this.repoAttributesFile = repositoryResolver.resolveWithCommonDir("info/attributes");
            } else {
                this.workTree = null;
                this.repoConfig = new Config();
                this.repoAttributesFile = null;
            }
        }

        private Runtime atRuntime() {
            return new Runtime(GitAttributesLineEndings.parseRules(this.repoAttributesFile), this.workTree, this.repoConfig, GitAttributesLineEndings.parseRules(this.globalAttributesFile));
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class CachedEndings
    implements Serializable {
        private static final long serialVersionUID = -2534772773057900619L;
        final transient String rootDir;
        final String defaultEnding;
        final ConcurrentRadixTree<String> hasNonDefaultEnding = new ConcurrentRadixTree((NodeFactory)new DefaultCharSequenceNodeFactory());

        CachedEndings(File projectDir, Runtime runtime, Iterable<File> toFormat) {
            String rootPath = FileSignature.pathNativeToUnix((String)projectDir.getAbsolutePath());
            this.rootDir = rootPath.equals("/") ? rootPath : rootPath + "/";
            this.defaultEnding = runtime.defaultEnding;
            for (File file : toFormat) {
                String ending = runtime.getEndingFor(file);
                if (ending.equals(this.defaultEnding)) continue;
                String absPath = FileSignature.pathNativeToUnix((String)file.getAbsolutePath());
                String subPath = FileSignature.subpath((String)this.rootDir, (String)absPath);
                this.hasNonDefaultEnding.put((CharSequence)subPath, (Object)ending);
            }
        }

        public String endingFor(File file) {
            String absPath = FileSignature.pathNativeToUnix((String)file.getAbsolutePath());
            String subpath = FileSignature.subpath((String)this.rootDir, (String)absPath);
            String ending = (String)this.hasNonDefaultEnding.getValueForExactKey((CharSequence)subpath);
            return ending == null ? this.defaultEnding : ending;
        }
    }

    static class RelocatablePolicy
    extends LazyForwardingEquality<CachedEndings>
    implements LineEnding.Policy {
        private static final long serialVersionUID = 5868522122123693015L;
        transient File projectDir;
        transient Supplier<Iterable<File>> toFormat;

        RelocatablePolicy(File projectDir, Supplier<Iterable<File>> toFormat) {
            this.projectDir = Objects.requireNonNull(projectDir, "projectDir");
            this.toFormat = Objects.requireNonNull(toFormat, "toFormat");
        }

        protected CachedEndings calculateState() throws Exception {
            Runtime runtime = new RuntimeInit(this.projectDir).atRuntime();
            CachedEndings state = new CachedEndings(this.projectDir, runtime, this.toFormat.get());
            this.projectDir = null;
            this.toFormat = null;
            return state;
        }

        public String getEndingFor(File file) {
            return ((CachedEndings)this.state()).endingFor(file);
        }
    }

    static class LazyAllTheSame
    extends LazyForwardingEquality<String>
    implements LineEnding.Policy {
        private static final long serialVersionUID = 727912266173243664L;
        transient File projectDir;
        transient Supplier<Iterable<File>> toFormat;

        public LazyAllTheSame(File projectDir, Supplier<Iterable<File>> toFormat) {
            this.projectDir = projectDir;
            this.toFormat = toFormat;
        }

        protected String calculateState() throws Exception {
            Iterator<File> files = this.toFormat.get().iterator();
            if (files.hasNext()) {
                Runtime runtime = new RuntimeInit(this.projectDir).atRuntime();
                return runtime.getEndingFor(files.next());
            }
            return LineEnding.UNIX.str();
        }

        public String getEndingFor(File file) {
            return (String)((Object)this.state());
        }
    }
}

